/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.model.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.fi.pa.enums.DataValueTypeEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.model.impl.BasePropModel;

public class PADimensionModel
extends BasePropModel {
    private static final long serialVersionUID = -3205289484341410814L;
    private DimensionTypeEnum dataType;
    private BasePropModel source;
    private DataValueTypeEnum dbType;

    @Override
    public void loadFromDynamicObject(DynamicObject sourceDynamicObject, boolean fetchBaseValue) {
        super.loadFromDynamicObject(sourceDynamicObject, fetchBaseValue);
        this.dataType = DimensionTypeEnum.getCode(sourceDynamicObject.getString("dimensiontype"));
        this.source = new BasePropModel();
        String sourceField = this.getSourceField();
        if (StringUtils.isNotBlank((CharSequence)sourceField)) {
            this.source.loadFromDynamicObject(sourceDynamicObject.getDynamicObject(sourceField), fetchBaseValue);
        }
        switch (this.dataType) {
            case NOTHING: 
            case OTHER: 
            case DENUMS: {
                this.dbType = DataValueTypeEnum.String;
                break;
            }
            case DATABASE: {
                this.dbType = PADimensionModel.isStringPrimaryKeyType((String)this.source.getId()) ? DataValueTypeEnum.String : DataValueTypeEnum.Int;
                break;
            }
            case ASSISTANTDATA: 
            case PERIOD: {
                this.dbType = DataValueTypeEnum.Int;
                break;
            }
            case DATE: {
                this.dbType = DataValueTypeEnum.Date;
                break;
            }
            default: {
                throw new KDBizException("unsupported dimension type " + sourceDynamicObject.getString("dimensiontype"));
            }
        }
    }

    private String getSourceField() {
        switch (this.dataType) {
            case DATABASE: 
            case PERIOD: {
                return "dimensionsource";
            }
            case ASSISTANTDATA: {
                return "assistantsource";
            }
        }
        return "";
    }

    public String valueToString(Object data) {
        Object value;
        if (data == null) {
            return "";
        }
        switch (this.dataType) {
            case DATABASE: 
            case ASSISTANTDATA: 
            case PERIOD: {
                Object object = data = data instanceof DynamicObject ? ((DynamicObject)data).getPkValue() : data;
                if (data instanceof Integer && (Integer)data == 0 || data instanceof Long && (Long)data == 0L) {
                    value = "";
                    break;
                }
                if (data instanceof String && " ".equals(data)) {
                    value = "";
                    break;
                }
                value = data;
                break;
            }
            case OTHER: 
            case DENUMS: {
                value = " ".equals(data) ? "" : data;
                break;
            }
            default: {
                value = data;
            }
        }
        return String.valueOf(value);
    }

    public static boolean isStringPrimaryKeyType(String baseEntityNUmber) {
        if (StringUtils.isEmpty((CharSequence)baseEntityNUmber)) {
            return false;
        }
        MainEntityType baseEntity = EntityMetadataCache.getDataEntityType((String)baseEntityNUmber);
        int type = baseEntity.getPrimaryKey().getDbType();
        return type == 12;
    }

    public void setDataType(DimensionTypeEnum dataType) {
        this.dataType = dataType;
    }

    public void setSource(BasePropModel source) {
        this.source = source;
    }

    public BasePropModel getSource() {
        return this.source;
    }

    public DimensionTypeEnum getDataType() {
        return this.dataType;
    }

    public DataValueTypeEnum getDbType() {
        return this.dbType;
    }

    public void setDbType(DataValueTypeEnum dbType) {
        this.dbType = dbType;
    }

    @Override
    public String toString() {
        return "PADimensionModel{v1=" + this.v1 + ", v2=" + (String)this.v2 + ", v3=" + this.v3 + ", dataType=" + (Object)((Object)this.dataType) + ", source=" + this.source + ", dbType=" + this.dbType + '}';
    }
}

