/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.stream.pipe;

import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.listener.IExceptionListener;
import kd.fi.pa.engine.task.IDataWorkTaskManager;
import kd.fi.pa.stream.datablock.IAsyncStreamDataBlock;
import kd.fi.pa.stream.datablock.SimpleAsyncStreamDataBlock;

public class AsyncStreamPipe<E> {
    private static final Log logger = LogFactory.getLog(AsyncStreamPipe.class);
    public static final int PIPE_NOT_RUNNING = 0;
    public static final int PIPE_STARTING = 1;
    public static final int PIPE_RUNNING = 2;
    public static final int PIPE_STOPPING = 3;
    protected ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> dataQueue = new ConcurrentLinkedQueue();
    protected Consumer<IAsyncStreamDataBlock<E>> dataConsumer;
    protected AtomicInteger pipeStatus = new AtomicInteger(0);
    protected AtomicInteger activeConsumerCnt = new AtomicInteger(0);
    protected IExceptionListener exceptionListener;
    protected int consumerThreadCnt;
    protected List<Future> consumerThreadRefs;

    public AsyncStreamPipe(int consumerThreadCnt) {
        this.consumerThreadCnt = consumerThreadCnt;
        this.consumerThreadRefs = new LinkedList<Future>();
    }

    public AsyncStreamPipe() {
        this(1);
    }

    public AsyncStreamPipe(int consumerThreadCnt, Consumer<IAsyncStreamDataBlock<E>> consumer) {
        this(consumerThreadCnt);
        this.attach(consumer);
    }

    public final void attach(Consumer<IAsyncStreamDataBlock<E>> consumer) {
        if (this.isRunning()) {
            try {
                this.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updatePipeStatus(1);
        this.dataConsumer = consumer;
        for (int i = 0; i < this.consumerThreadCnt; ++i) {
            this.consumerThreadRefs.add(IDataWorkTaskManager.getInstance().submit(() -> this.doDataConsume(consumer), true));
        }
        this.updatePipeStatus(2);
    }

    protected void updatePipeStatus(int statusCode) {
        this.pipeStatus.set(statusCode);
    }

    public boolean isStopped() {
        int status = this.pipeStatus.get();
        return status == 0 || status == 3;
    }

    public boolean isRunning() {
        int status = this.pipeStatus.get();
        return status == 2 || status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDataConsume(Consumer<IAsyncStreamDataBlock<E>> consumer) {
        this.activeConsumerCnt.incrementAndGet();
        AtomicInteger atomicInteger = this.activeConsumerCnt;
        synchronized (atomicInteger) {
            this.activeConsumerCnt.notifyAll();
        }
        while (this.isRunning()) {
            try {
                ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue;
                IAsyncStreamDataBlock<E> dataBlock = this.dataQueue.poll();
                if (dataBlock != null) {
                    if (this.dataQueue.isEmpty()) {
                        concurrentLinkedQueue = this.dataQueue;
                        synchronized (concurrentLinkedQueue) {
                            this.dataQueue.notifyAll();
                        }
                    }
                    consumer.accept(dataBlock);
                    continue;
                }
                concurrentLinkedQueue = this.dataQueue;
                synchronized (concurrentLinkedQueue) {
                    this.dataQueue.wait(5000L);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                if (this.exceptionListener == null) continue;
                this.exceptionListener.onError(ex);
            }
        }
        int result = this.activeConsumerCnt.decrementAndGet();
        AtomicInteger atomicInteger2 = this.activeConsumerCnt;
        synchronized (atomicInteger2) {
            this.activeConsumerCnt.notifyAll();
        }
        return result;
    }

    protected static void closeClosable(Closeable src) {
        if (src != null) {
            try {
                src.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws InterruptedException {
        if (this.isRunning()) {
            if (force) {
                this.dataQueue.clear();
            } else {
                while (!this.dataQueue.isEmpty()) {
                    ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
                    synchronized (concurrentLinkedQueue) {
                        this.dataQueue.wait(5000L);
                    }
                }
            }
            this.updatePipeStatus(3);
            for (Future future : this.consumerThreadRefs) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
            this.updatePipeStatus(0);
        }
    }

    public void close() throws InterruptedException {
        this.close(false);
    }

    public void putToQueue(Collection<E> srcDatas) throws InterruptedException {
        for (E src : srcDatas) {
            this.putToQueue(src);
        }
    }

    public void putToQueue(E srcData) throws InterruptedException {
        this.putToQueue(new SimpleAsyncStreamDataBlock<E>(srcData));
    }

    public void putToQueue(E srcData, int requiredNewPage, int requiredFlush, boolean last) throws InterruptedException {
        this.putToQueue(new SimpleAsyncStreamDataBlock<E>(srcData, requiredNewPage, requiredFlush, last));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putToQueue(IAsyncStreamDataBlock<E> srcData) throws InterruptedException {
        this.dataQueue.offer(srcData);
        ConcurrentLinkedQueue<IAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
        synchronized (concurrentLinkedQueue) {
            this.dataQueue.notifyAll();
        }
    }

    public IAsyncStreamDataBlock<E> peekFromQueue() {
        return this.dataQueue.peek();
    }

    public int queueSize() {
        return this.dataQueue.size();
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty();
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public Consumer<IAsyncStreamDataBlock<E>> getDataConsumer() {
        return this.dataConsumer;
    }

    public int getConsumerThreadCnt() {
        return this.consumerThreadCnt;
    }

    public void setConsumerThreadCnt(int consumerThreadCnt) {
        this.consumerThreadCnt = consumerThreadCnt;
    }

    public int getActiveConsumerCnt() {
        return this.activeConsumerCnt.get();
    }

    public void setDataConsumer(Consumer<IAsyncStreamDataBlock<E>> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    public int getPipeStatus() {
        return this.pipeStatus.get();
    }
}

