/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T[]> splitArray(T[] sourceArray, int chunkSize) {
        if (sourceArray == null || chunkSize <= 0) {
            throw new KDBizException("sourceArray or chunkSize is invalid");
        }
        ArrayList<T[]> result = new ArrayList<T[]>(16);
        for (int i = 0; i < sourceArray.length; i += chunkSize) {
            int realChunkSize = Math.min(chunkSize, sourceArray.length - i);
            Object[] chunkArray = (Object[])Array.newInstance(sourceArray.getClass().getComponentType(), realChunkSize);
            System.arraycopy(sourceArray, i, chunkArray, 0, chunkArray.length);
            result.add(chunkArray);
        }
        return result;
    }

    public static <T> List<T[]> splitArrayLimitSize(T[] sourceArray, int listMaxSize) {
        int remainCount;
        if (sourceArray == null || listMaxSize <= 0) {
            throw new KDBizException("sourceArray or listMaxSize is invalid");
        }
        int chunkSize = Math.max(1, sourceArray.length / listMaxSize);
        ArrayList<T[]> splitList = new ArrayList<T[]>(listMaxSize);
        int total = 0;
        for (int i = 0; i < listMaxSize; ++i) {
            int start = i * chunkSize;
            int chunkArraySize = Math.min(chunkSize, sourceArray.length - start);
            Object[] chunkArray = (Object[])Array.newInstance(sourceArray.getClass().getComponentType(), chunkArraySize);
            System.arraycopy(sourceArray, start, chunkArray, 0, chunkArray.length);
            splitList.add(chunkArray);
            if ((total += chunkArray.length) >= sourceArray.length) break;
        }
        if ((remainCount = sourceArray.length - total) > 0) {
            int receiverIndex = splitList.size() - 1;
            Object[] lastArray = (Object[])splitList.get(receiverIndex);
            Object[] receiverArray = (Object[])Array.newInstance(sourceArray.getClass().getComponentType(), lastArray.length + remainCount);
            System.arraycopy(lastArray, 0, receiverArray, 0, lastArray.length);
            System.arraycopy(sourceArray, total, receiverArray, lastArray.length, remainCount);
            splitList.set(receiverIndex, receiverArray);
        }
        return splitList;
    }
}

