/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class DateUtil {
    private static final int[] QUARTER = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String getYearAndMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return year + "-" + month;
    }

    public static Date[] getMothStartAndEnd(String yearAndMonthStr) {
        String[] yearAndMonths = yearAndMonthStr.split("-");
        int year = Integer.parseInt(yearAndMonths[0]);
        int month = Integer.parseInt(yearAndMonths[1]);
        Date[] rangDate = new Date[2];
        GregorianCalendar startCal = new GregorianCalendar();
        startCal.set(1, year);
        startCal.set(2, month - 1);
        startCal.set(5, 1);
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        rangDate[0] = startCal.getTime();
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.set(1, year);
        endCal.set(2, month - 1);
        endCal.set(5, ((Calendar)endCal).getActualMaximum(5));
        endCal.set(11, 23);
        endCal.set(12, 59);
        endCal.set(13, 59);
        endCal.set(14, 999);
        rangDate[1] = endCal.getTime();
        return rangDate;
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i);
        return cal.getTime();
    }

    public static boolean isFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5) == 1;
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtil.getDataFormat(date, true);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtil.getDataFormat(date, false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getNextMonthLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        cal.set(5, cal.getActualMaximum(5));
        return DateUtil.getMaxMonthDate(cal.getTime());
    }

    public static Date getNextMonthFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getLastQuarter(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i * 3);
        return cal.getTime();
    }

    public static Date getNextQuarter(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i * 3);
        return cal.getTime();
    }

    public static Date getLastYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) - i);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) + i);
        return cal.getTime();
    }

    public static int getDay(Date date) {
        return DateUtil.date2LocalDate(date).getDayOfMonth();
    }

    public static int getMonth(Date date) {
        return DateUtil.date2LocalDate(date).getMonthValue();
    }

    public static int getQuarter(Date date) {
        return QUARTER[DateUtil.getMonth(date) - 1];
    }

    public static int getYear(Date date) {
        return DateUtil.date2LocalDate(date).getYear();
    }

    public static Date getMinDate(Date d1, Date d2) {
        return d1.getTime() > d2.getTime() ? d2 : d1;
    }

    public static boolean isLarger(Date d1, Date d2) {
        return d1.getTime() > d2.getTime();
    }

    public static LocalDate date2LocalDate(Date date) {
        return DateUtil.date2LocalDateTime(date).toLocalDate();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE);
    }
}

