/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.enums.ExecutionModeEnum;

public class ExecutionLogUtil {
    public static ExecutionLogDTO buildLogDTO(DynamicObject dyo, String executionType, List<Long> idList, ExecutionModeEnum executionModeEnum) {
        ExecutionLogDTO dto = new ExecutionLogDTO();
        dto.setBusinessIdList(idList);
        dto.setAnalysisSystem(dyo.getLong("analysissystem_id"));
        dto.setAnalysisModel(dyo.getLong("analysismodel_id"));
        dto.setOrgIds(new Long[]{dyo.getLong("createorg_id")});
        dto.setExecutionMode(executionModeEnum);
        dto.setItemClassTypeField(dyo.getString("periodbasetype"));
        dto.setStartPeriod(dyo.getLong("period_id"));
        dto.setExecutionTime(new Date());
        dto.setDetailTime(System.currentTimeMillis());
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        dto.setExecutionType(executionType);
        return dto;
    }

    public static ExecutionLogDTO buildLogDTOByPlainObject(DynamicObject dyo, String executionType, List<Long> idList, ExecutionModeEnum executionModeEnum) {
        ExecutionLogDTO dto = new ExecutionLogDTO();
        dto.setBusinessIdList(idList);
        dto.setAnalysisSystem(dyo.getLong("analysissystem"));
        dto.setAnalysisModel(dyo.getLong("analysismodel"));
        dto.setOrgIds(new Long[]{dyo.getLong("createorg")});
        dto.setExecutionMode(executionModeEnum);
        dto.setItemClassTypeField(dyo.getString("periodbasetype"));
        dto.setStartPeriod(dyo.getLong("period"));
        dto.setExecutionTime(new Date());
        dto.setDetailTime(System.currentTimeMillis());
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        dto.setExecutionType(executionType);
        return dto;
    }
}

