/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.pa.builder.IJsonObjectBuilder;

public abstract class IDataJsonUtil
implements IJsonObjectBuilder {
    protected final Map<Class, IJsonObjectBuilder> jsonClassBuilderMap = new HashMap<Class, IJsonObjectBuilder>();

    public abstract <T extends IDataJsonUtil> T getDefaultInstance();

    protected IDataJsonUtil() {
    }

    public void registerJSonClassFactory(Class<?> targetClass, IJsonObjectBuilder jsonObjBuilder) {
        this.jsonClassBuilderMap.put(targetClass, jsonObjBuilder);
    }

    public static String toJSONString(Object source) {
        if (source == null) {
            return null;
        }
        return JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    @Override
    public <T> T parseJsonString(String jsonText, Class<T> clazz, Feature ... features) {
        return (T)JSON.parseObject((String)jsonText, clazz, (Feature[])features);
    }

    public boolean hasIJsonObjectBuilder(Class<?> targetClass) {
        return this.jsonClassBuilderMap.containsKey(targetClass);
    }

    public <T> T parseObject(String text, Class<T> clazz, Feature ... features) {
        return this.jsonClassBuilderMap.getOrDefault(clazz, (IJsonObjectBuilder)this.getDefaultInstance()).parseJsonString(text, clazz, features);
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        return JSON.parseObject((String)text, (Feature[])features);
    }

    public static JSONArray parseArray(String text) {
        return JSON.parseArray((String)text);
    }

    public static boolean isJSonFormat(String srcString, String ... checkContainString) {
        if (srcString == null) {
            return false;
        }
        String strBuf = srcString.trim();
        if (!strBuf.startsWith("{") || !strBuf.endsWith("}")) {
            return false;
        }
        if (checkContainString != null && checkContainString.length > 0) {
            for (String s : checkContainString) {
                if (strBuf.contains(s)) continue;
                return false;
            }
        }
        return true;
    }

    public static byte[] toByte(Object o) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    public static Object fromByte(byte[] bytes) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    public static String serializeToBase64(Object o) {
        return Base64.getEncoder().encodeToString(IDataJsonUtil.toByte(o));
    }

    public static <T> T deSerializeFromBase64(String base64String) {
        return (T)IDataJsonUtil.fromByte(Base64.getDecoder().decode(base64String));
    }
}

