/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.util.StringUtils;
import kd.fi.pa.enums.DataValueTypeEnum;
import kd.fi.pa.enums.IByteCodeEnum;
import kd.fi.pa.utils.IDataJsonUtil;
import org.apache.commons.lang.IllegalClassException;

public class IDataValueUtil {
    static final SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy.MM.dd"), new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("MM.dd.yyyy"), new SimpleDateFormat("dd/MM/yyyy"), new SimpleDateFormat("dd-MM-yyyy"), new SimpleDateFormat("dd.MM.yyyy")};

    public static IDataEntityProperty getDataEntityProperty(DynamicObject sourceDyn, String propertyName) {
        return (IDataEntityProperty)sourceDyn.getDataEntityType().getProperties().get((Object)propertyName);
    }

    public static <T> T getDynPropValue(DynamicObject sourceDyn, String propertyName, Class<T> clazzType) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        if (prop == null) {
            return null;
        }
        return (T)ObjectConverter.convert((Object)prop.getValueFast((Object)sourceDyn), clazzType, (boolean)false);
    }

    public static Object getDynPropValue(DynamicObject sourceDyn, String propertyName) {
        IDataEntityProperty prop = IDataValueUtil.getDataEntityProperty(sourceDyn, propertyName);
        return prop == null ? null : prop.getValueFast((Object)sourceDyn);
    }

    public static Byte getByteCodeEnumCode(IByteCodeEnum<?> val) {
        return val == null ? null : Byte.valueOf(val.getCode());
    }

    public static JSONArray toJSONArray(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof String) {
            String jsonStr = source.toString();
            if (IDataJsonUtil.isJSonFormat(jsonStr, new String[0])) {
                return IDataValueUtil.toJSONArray(IDataJsonUtil.parseObject(jsonStr, new Feature[0]));
            }
        } else {
            if (source instanceof JSONArray) {
                return (JSONArray)source;
            }
            if (source instanceof JSONObject) {
                return ((JSONObject)source).getJSONArray("v");
            }
        }
        throw new IllegalClassException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
    }

    public static Object getObject(Object[] v, int index) {
        return v == null || index < 0 || index >= v.length ? null : v[index];
    }

    public static <T> T[] parseArrayObject(Object sourceObject, Class<T> targetClassType) {
        JSONArray targetJsonArray = IDataValueUtil.toJSONArray(sourceObject);
        return targetJsonArray == null ? null : targetJsonArray.toArray((Object[])Array.newInstance(targetClassType, 0));
    }

    public static int[] getIntArray(Object[] objectArray, int index) {
        return IDataValueUtil.getIntArray(objectArray[index]);
    }

    public static int[] getIntArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        int[] result = new int[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].intValue();
            }
        }
        return result;
    }

    public static long[] getLongArray(Object object) {
        Number[] arrayBuf = IDataValueUtil.parseArrayObject(object, Number.class);
        if (arrayBuf == null) {
            return null;
        }
        long[] result = new long[arrayBuf.length];
        if (result.length > 0) {
            for (int i = 0; i < arrayBuf.length; ++i) {
                if (arrayBuf[i] == null) continue;
                result[i] = arrayBuf[i].longValue();
            }
        }
        return result;
    }

    public static long[] getLongArray(Object[] v, int index) {
        return IDataValueUtil.getLongArray(v[index]);
    }

    public static Boolean getBoolean(Object[] v, int index) {
        return IDataValueUtil.getBoolean(IDataValueUtil.getObject(v, index));
    }

    public static Byte getByte(Object[] v, int index) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return Byte.valueOf(value.toString());
    }

    public static String getString(Object[] v, int index, boolean trim) {
        Object value = IDataValueUtil.getObject(v, index);
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static String getString(Object[] v, int index) {
        return IDataValueUtil.getString(v, index, false);
    }

    public static String getString(Object value) {
        return IDataValueUtil.getString(value, false);
    }

    public static String getString(Object value, boolean trim) {
        if (value == null) {
            return null;
        }
        return trim ? String.valueOf(value).trim() : String.valueOf(value);
    }

    public static Date getDate(Object[] v, int index) {
        return IDataValueUtil.getDate(IDataValueUtil.getObject(v, index));
    }

    public static Date getDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof Date) {
            return (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
        }
        if (value instanceof String) {
            String srcBuf = (String)value;
            if (srcBuf.contains("/") || srcBuf.contains("-") || srcBuf.contains(".")) {
                for (SimpleDateFormat formatter : dateFormats) {
                    try {
                        return formatter.parse(srcBuf);
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                try {
                    return new Date(Long.parseLong((String)value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Long getLong(Object[] v, int index) {
        return IDataValueUtil.getLong(IDataValueUtil.getObject(v, index));
    }

    public static Long getLong(Object value) {
        return value == null ? null : (Long)ObjectConverter.convert((Object)value, Long.class, (boolean)false);
    }

    public static Boolean getBoolean(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static BigDecimal getBigDecimal(Object value) {
        return value == null ? null : (BigDecimal)ObjectConverter.convert((Object)value, BigDecimal.class, (boolean)false);
    }

    public static Boolean isBooleanValue(Object value) {
        if (value != null) {
            String code;
            switch (code = String.valueOf(value).toLowerCase(Locale.ENGLISH)) {
                case "y": 
                case "yes": 
                case "t": 
                case "true": 
                case "1": 
                case "n": 
                case "no": 
                case "f": 
                case "false": 
                case "0": {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    public static Date getDate(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        for (SimpleDateFormat formatter : dateFormats) {
            try {
                return formatter.parse(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static DataValueTypeEnum getDataType(IDataEntityProperty fieldProp) {
        if (fieldProp != null) {
            Class propType = fieldProp.getPropertyType();
            if (Number.class.isAssignableFrom(propType)) {
                if (Integer.class.isAssignableFrom(propType) || Long.class.isAssignableFrom(propType) || Short.class.isAssignableFrom(propType) || Byte.class.isAssignableFrom(propType)) {
                    return DataValueTypeEnum.Int;
                }
                return DataValueTypeEnum.Double;
            }
            if (Date.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Date;
            }
            if (Boolean.class.isAssignableFrom(propType) || Boolean.TYPE.isAssignableFrom(propType)) {
                return DataValueTypeEnum.Bool;
            }
            if (DynamicObject.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.BaseProp;
            }
            if (String.class.isAssignableFrom(propType)) {
                return DataValueTypeEnum.String;
            }
        }
        return DataValueTypeEnum.String;
    }
}

