/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.model.impl.PADimensionModel;

public class ModelUtil {
    private static final Log logger = LogFactory.getLog(ModelUtil.class);

    private ModelUtil() {
    }

    public static boolean isExistField(String entityNumber, String fieldNumber) {
        return MetadataServiceHelper.getDataEntityType((String)entityNumber).getProperties().stream().anyMatch(iDataEntityProperty -> fieldNumber.equals(iDataEntityProperty.getName()));
    }

    public static DataType getDataType(String entityNumber, String fieldNumber) {
        RowMeta rowMeta = ORM.create().createRowMeta(entityNumber, fieldNumber);
        Field field = rowMeta.getField(fieldNumber);
        return field.getDataType();
    }

    public static String getDimValue(String type, String text) {
        return ModelUtil.getDimValue(type, text, null, null);
    }

    public static String getDimValue(String type, String text, String idStr, String valueStr) {
        String value;
        block6: {
            DimensionTypeEnum dimType;
            block5: {
                value = null;
                dimType = DimensionTypeEnum.getEnum(type);
                if (!StringUtils.isNotBlank((CharSequence)text)) break block5;
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: 
                    case DENUMS: {
                        Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        value = String.join((CharSequence)",", map.keySet());
                        break block6;
                    }
                    case OTHER: {
                        value = text.replace('\n', ',');
                        break block6;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block6;
                    }
                    default: {
                        throw new KDBizException("dimType error");
                    }
                }
            }
            value = dimType == DimensionTypeEnum.OTHER ? valueStr : idStr;
        }
        return value;
    }

    public static DataType getDimDataType(String type, String entityNumber) {
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(type);
        switch (dimType) {
            case DATABASE: {
                return ModelUtil.getDataType(entityNumber, "id");
            }
            case ASSISTANTDATA: 
            case PERIOD: {
                return DataType.LongType;
            }
            case DENUMS: 
            case OTHER: {
                return DataType.StringType;
            }
            case DATE: {
                return DataType.DateType;
            }
            case NOTHING: {
                return DataType.NullType;
            }
        }
        throw new KDBizException("dimType error");
    }

    public static QFilter getDimQFilter(String type, String number, String baseEntityId, String condition, String value) {
        QFilter qFilter = null;
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum(type);
        FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum(condition);
        block0 : switch (conditionEnum) {
            case IS_NULL: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType(baseEntityId);
                        qFilter = isString ? new QFilter(number, "=", (Object)"").or(number, "=", (Object)" ").or(number, "is null", null) : new QFilter(number, "=", (Object)0);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        qFilter = new QFilter(number, "=", (Object)"").or(number, "=", (Object)" ").or(number, "is null", null);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new KDBizException("dimType error");
            }
            case IS_NOTNULL: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType(baseEntityId);
                        qFilter = isString ? new QFilter(number, "!=", (Object)"").and(number, "!=", (Object)" ").and(number, "is not null", null) : new QFilter(number, "!=", (Object)0);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        qFilter = new QFilter(number, "!=", (Object)"").and(number, "!=", (Object)" ").and(number, "is not null", null);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new KDBizException("dimType error");
            }
            case IN: 
            case NOT_IN: {
                switch (dimType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        boolean isString = PADimensionModel.isStringPrimaryKeyType(baseEntityId);
                        List idList = Stream.of(value.split(",")).map(idStr -> isString ? idStr : Long.valueOf(idStr)).collect(Collectors.toList());
                        qFilter = new QFilter(number, conditionEnum.getValue(), idList);
                        break block0;
                    }
                    case DENUMS: 
                    case OTHER: {
                        String[] values = value.split(",");
                        qFilter = new QFilter(number, conditionEnum.getValue(), (Object)values);
                        break block0;
                    }
                    case PERIOD: 
                    case DATE: 
                    case NOTHING: {
                        break block0;
                    }
                }
                throw new KDBizException("dimType error");
            }
            case ALL: {
                break;
            }
            default: {
                throw new KDBizException("dimType error");
            }
        }
        return qFilter;
    }

    public static boolean dimValueIsEmpty(Object fieldValue) {
        if (fieldValue == null) {
            return true;
        }
        try {
            if (fieldValue instanceof Long) {
                return (Long)fieldValue == 0L;
            }
            if (fieldValue instanceof Integer) {
                return (Integer)fieldValue == 0;
            }
            if (fieldValue instanceof OrmLocaleValue || fieldValue instanceof String) {
                return " ".equals(fieldValue = fieldValue.toString()) || "".equals(fieldValue);
            }
        }
        catch (Exception e) {
            logger.error("[FI-PA] ModelUtil type&value is not mate", (Throwable)e);
            return true;
        }
        return false;
    }
}

