/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import java.time.LocalDate;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.dto.DateRangeDTO;

public class PAUtil {
    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static boolean idNotNull(Object pkvalue) {
        return !PAUtil.idIsNull(pkvalue);
    }

    public static boolean idIsNull(Object pkvalue) {
        if (pkvalue instanceof Integer) {
            pkvalue = (long)((Integer)pkvalue).intValue();
        }
        return pkvalue == null || Objects.equals(pkvalue, 0L);
    }

    public static <T> T safeGet(DynamicObject dynamicObject, String propertyName) {
        if (dynamicObject == null) {
            return null;
        }
        Object o = dynamicObject.get(propertyName);
        if (o == null || o instanceof String && StringUtils.isEmpty((CharSequence)((CharSequence)o))) {
            DynamicProperty property = dynamicObject.getDynamicObjectType().getProperty(propertyName);
            String name = property == null ? propertyName : property.getDisplayName().toString();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a.", (String)"PAUtil_0", (String)"fi-pa-common", (Object[])new Object[0]), name));
        }
        return PAUtil.cast(o);
    }

    public static <T> T safeGet(DynamicObject dynamicObject, String propertyName, T defaultV) {
        if (dynamicObject == null) {
            return defaultV;
        }
        return PAUtil.cast(dynamicObject.get(propertyName));
    }

    public static Long safeToLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static QFilter timeSection(String property, DateRangeDTO dateRange) {
        LocalDate startDate = dateRange.getStartLocalDate();
        LocalDate endDate = dateRange.getEndLocalDate();
        if (endDate == null) {
            if (startDate == null) {
                return null;
            }
            return QFilter.of((String)(property + " >= ?"), (Object[])new Object[]{startDate});
        }
        if (startDate == null) {
            return QFilter.of((String)(property + " <= ?"), (Object[])new Object[]{endDate.plusDays(1L)});
        }
        return QFilter.of((String)(property + " >= ? and " + property + " < ?"), (Object[])new Object[]{startDate, endDate.plusDays(1L)});
    }
}

