/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.utils;

import java.util.HashSet;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;

public final class ShardingUtil {
    public static boolean isShardingEntity(String entityNumber) {
        ShardingConfig tableConfig = ShardingUtil.getShardingConfig(entityNumber);
        return tableConfig != null && tableConfig.isEnabled();
    }

    private static ShardingConfig getShardingConfig(String entityNumber) {
        return XDBConfig.getShardingConfigProvider().getConfig("t_" + entityNumber);
    }

    public static Set<String> getShardingFields(String entityNumber) {
        HashSet<String> shardingFieldSet = new HashSet<String>(8);
        ShardingConfig tableConfig = ShardingUtil.getShardingConfig(entityNumber);
        if (tableConfig != null && tableConfig.isEnabled()) {
            String[] originShardingFields;
            for (String field : originShardingFields = tableConfig.getShardingFields()) {
                shardingFieldSet.add(field.substring(1));
            }
        }
        return shardingFieldSet;
    }
}

