/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.algox;

import java.io.Serializable;
import java.util.LinkedList;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.fi.pa.algox.PARowXProcessor;

public class PARowMetaBuilder
implements Serializable {
    private static final long serialVersionUID = -9219565611824040739L;
    private final RowMeta rowMeta;

    public PARowMetaBuilder(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public PARowXProcessor create(RowX rowX) {
        return new PARowXProcessor(this.rowMeta, rowX);
    }

    public PARowXProcessor createCopy(RowX rowX) {
        return this.create(rowX.copy());
    }

    public PARowXProcessor createNew() {
        int count = this.rowMeta.getFieldCount();
        return this.create(new RowX(count));
    }

    public PARowXProcessor createConversion(PARowXProcessor sourcePARowXProcessor) {
        Field[] targetFields = this.rowMeta.getFields();
        int length = targetFields.length;
        Object[] targetFieldValues = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object sourceValue;
            Field targetField = targetFields[i];
            String targetFieldName = targetField.getName();
            targetFieldValues[i] = sourceValue = sourcePARowXProcessor.getValue(targetFieldName);
        }
        RowX targetRowX = new RowX(targetFieldValues);
        return this.create(targetRowX);
    }

    public PARowMetaBuilder addFields(Field ... addFields) {
        Field[] fields = this.rowMeta.getFields();
        Field[] newFields = new Field[fields.length + addFields.length];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        System.arraycopy(addFields, 0, newFields, fields.length, addFields.length);
        RowMeta newRowMeta = new RowMeta(newFields);
        return new PARowMetaBuilder(newRowMeta);
    }

    public PARowMetaBuilder delFields(Field ... delFields) {
        Field[] fields = this.rowMeta.getFields();
        LinkedList<Field> newFieldList = new LinkedList<Field>();
        for (Field field : fields) {
            boolean flag = true;
            for (Field delField : delFields) {
                if (!field.getName().equals(delField.getName())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            newFieldList.add(field);
        }
        RowMeta newRowMeta = new RowMeta(newFieldList.toArray(new Field[0]));
        return new PARowMetaBuilder(newRowMeta);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

