/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.algox;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algox.RowX;

public class PARowXProcessor
implements Serializable {
    private static final long serialVersionUID = 644540580786607676L;
    private final RowMeta rowMeta;
    private final RowX rowX;

    public PARowXProcessor(RowMeta rowMeta, RowX rowX) {
        this.rowMeta = rowMeta;
        this.rowX = rowX;
    }

    public Object getValue(String fieldName) {
        int index = this.rowMeta.getFieldIndex(fieldName, false);
        return index >= 0 ? this.rowX.get(index) : null;
    }

    public Map<String, Object> getValue(List<String> fieldNameList) {
        HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(fieldNameList.size());
        for (String fieldName : fieldNameList) {
            Object value = this.getValue(fieldName);
            fieldValueMap.put(fieldName, value);
        }
        return fieldValueMap;
    }

    public DataType getValueType(String fieldName) {
        Field field = this.rowMeta.getField(fieldName, false);
        return field != null ? field.getDataType() : null;
    }

    public Object getValueSpecial(String fieldName) {
        Object fieldValue = this.getValue(fieldName);
        DataType fieldDataType = this.getValueType(fieldName);
        if (fieldValue == null || fieldDataType == null) {
            return null;
        }
        boolean emptyValueFlag = false;
        if (fieldDataType instanceof StringType) {
            boolean bl = emptyValueFlag = " ".equals(fieldValue) || "".equals(fieldValue);
        }
        if (fieldDataType instanceof LongType) {
            boolean bl = emptyValueFlag = (Long)fieldValue == 0L;
        }
        if (fieldDataType instanceof IntegerType) {
            emptyValueFlag = (Integer)fieldValue == 0;
        }
        return emptyValueFlag ? null : fieldValue;
    }

    public PARowXProcessor updateValue(String field, Object value) {
        int index = this.rowMeta.getFieldIndex(field, false);
        if (index >= 0) {
            this.rowX.set(index, value);
        }
        return this;
    }

    public PARowXProcessor updateValue(Map<String, Object> fieldValueMap) {
        for (Map.Entry<String, Object> entry : fieldValueMap.entrySet()) {
            this.updateValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public PARowXProcessor updateValueSpecial(String field, Object value) {
        int index = this.rowMeta.getFieldIndex(field, false);
        if (index >= 0) {
            DataType dataType = this.rowMeta.getDataType(index);
            if (dataType.acceptsType((DataType)DataType.LongType) && value instanceof Integer) {
                this.rowX.set(index, (Object)((Integer)value));
                return this;
            }
            this.rowX.set(index, value);
        }
        return this;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public RowX getRowX() {
        return this.rowX;
    }
}

