/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.algox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;

public class PASQLBuilder {
    private final String tableNumber;
    private final LinkedHashMap<String, String> kvMap;
    private final LinkedHashMap<String, String> whereMap;
    private final List<DataType> dataTypes;
    private final List<Object> params;

    public PASQLBuilder(String tableNumber) {
        this.tableNumber = tableNumber;
        this.kvMap = new LinkedHashMap(10);
        this.whereMap = new LinkedHashMap(10);
        this.dataTypes = new ArrayList<DataType>(10);
        this.params = new ArrayList<Object>(10);
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public PASQLBuilder params(Object ... objects) {
        this.params.addAll(Arrays.asList(objects));
        return this;
    }

    public PASQLBuilder addParams(Collection<?> objects) {
        this.params.addAll(objects);
        return this;
    }

    public PASQLBuilder insert(String ... ks) {
        for (String k : ks) {
            this.kvMap.put(k, "?");
        }
        return this;
    }

    public PASQLBuilder insert(String k, DataType dataType) {
        this.kvMap.put(k, "?");
        this.dataTypes.add(dataType);
        return this;
    }

    public PASQLBuilder insert(String k, String v) {
        this.kvMap.put(k, v);
        return this;
    }

    public PASQLBuilder set(String ... ks) {
        for (String k : ks) {
            this.kvMap.put(k, "?");
        }
        return this;
    }

    public PASQLBuilder set(String k, DataType dataType) {
        this.kvMap.put(k, "?");
        this.dataTypes.add(dataType);
        return this;
    }

    public PASQLBuilder set(String k, String v) {
        this.kvMap.put(k, v);
        return this;
    }

    public PASQLBuilder where() {
        return this;
    }

    public PASQLBuilder where(String k) {
        this.whereMap.put(k, " = ? ");
        return this;
    }

    public PASQLBuilder where(String k, DataType dataType) {
        this.whereMap.put(k, " = ? ");
        this.dataTypes.add(dataType);
        return this;
    }

    public PASQLBuilder where(String k, String v) {
        this.whereMap.put(k, " = " + v);
        return this;
    }

    public PASQLBuilder eq(String k, String v) {
        this.whereMap.put(k, " = " + v);
        return this;
    }

    public PASQLBuilder eq(String k, DataType dateType) {
        this.whereMap.put(k, " = ? ");
        this.dataTypes.add(dateType);
        return this;
    }

    public PASQLBuilder wherein(String k, int inSize) {
        Object[] strs = new String[inSize];
        Arrays.fill(strs, "?");
        this.whereMap.put(k, " in (" + String.join((CharSequence)",", (CharSequence[])strs) + ") ");
        return this;
    }

    public PASQLBuilder in(String k, int inSize) {
        Object[] strs = new String[inSize];
        Arrays.fill(strs, "?");
        this.whereMap.put(k, " in (" + String.join((CharSequence)",", (CharSequence[])strs) + ") ");
        return this;
    }

    public PASQLBuilder betweenAnd(String k, DataType dateType) {
        this.whereMap.put(k, " >= ? and " + k + " < ? ");
        this.dataTypes.add(dateType);
        this.dataTypes.add(dateType);
        return this;
    }

    public PASQLBuilder largeEquals(String k, DataType dateType) {
        this.whereMap.put(k, " >= ?");
        this.dataTypes.add(dateType);
        return this;
    }

    public PASQLBuilder lessThan(String k, DataType dateType) {
        this.whereMap.put(k, " < ? ");
        this.dataTypes.add(dateType);
        return this;
    }

    public PASQLBuilder type(DataType dataType) {
        this.dataTypes.add(dataType);
        return this;
    }

    public PASQLBuilder wherein(String k, Object ... vs) {
        String collect = Arrays.stream(vs).map(o -> o + "").collect(Collectors.joining(","));
        this.whereMap.put(k, " in (" + collect + ") ");
        return this;
    }

    public PASQLBuilder in(String k, Object ... vs) {
        String collect = Arrays.stream(vs).map(o -> o + "").collect(Collectors.joining(","));
        this.whereMap.put(k, " in (" + collect + ") ");
        return this;
    }

    public String toInsertSQL() {
        StringBuilder builder = new StringBuilder("insert into ");
        builder.append(this.tableNumber);
        builder.append('(');
        String collect = String.join((CharSequence)",", this.kvMap.keySet());
        builder.append(collect);
        builder.append(')');
        builder.append(" values(");
        String endStr = String.join((CharSequence)",", this.kvMap.values());
        builder.append(endStr);
        builder.append(')');
        return builder.toString();
    }

    public String toUpdateSQL() {
        StringBuilder builder = new StringBuilder("update ");
        builder.append(this.tableNumber);
        builder.append(" set ");
        String setSQL = this.kvMap.entrySet().stream().map(entry -> (String)entry.getKey() + " = " + (String)entry.getValue()).collect(Collectors.joining(","));
        builder.append(setSQL);
        builder.append(" where ");
        String whereSQL = this.whereMap.entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).collect(Collectors.joining(" and "));
        builder.append(whereSQL);
        return builder.toString();
    }

    public String toSelectSQL(String selectFields) {
        StringBuilder builder = new StringBuilder("select ");
        builder.append(selectFields);
        builder.append(" from ");
        builder.append(this.tableNumber);
        builder.append(" where ");
        String whereSQL = this.whereMap.entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).collect(Collectors.joining(" and "));
        builder.append(whereSQL);
        return builder.toString();
    }

    public String toDeleteSQL() {
        StringBuilder builder = new StringBuilder("delete from ");
        builder.append(this.tableNumber);
        builder.append(" where ");
        String whereSQL = this.whereMap.entrySet().stream().map(entry -> (String)entry.getKey() + (String)entry.getValue()).collect(Collectors.joining(" and "));
        builder.append(whereSQL);
        return builder.toString();
    }

    public String getCommonUpdateSQL() {
        StringBuilder builder = new StringBuilder("update ");
        builder.append(this.tableNumber);
        builder.append(" set fdel = 0 ");
        builder.append(" where fid = ? ");
        return builder.toString();
    }

    public String getCommonDeleteSQL() {
        StringBuilder builder = new StringBuilder("delete from ");
        builder.append(this.tableNumber);
        builder.append(" where fid = ? ");
        return builder.toString();
    }

    public RowMeta getRowMeta() {
        ArrayList<String> arrayList = new ArrayList<String>(this.kvMap.size() + this.whereMap.size());
        for (Map.Entry<String, String> entry : this.kvMap.entrySet()) {
            if (!entry.getValue().contains("?")) continue;
            arrayList.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.whereMap.entrySet()) {
            if (!entry.getValue().contains("?")) continue;
            arrayList.add(entry.getKey());
        }
        return new RowMeta(arrayList.toArray(new String[0]), this.dataTypes.toArray(new DataType[0]));
    }
}

