/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.algox;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class XDbGroupOutput
implements CustomizedOutput {
    private static final long serialVersionUID = 1553432677433L;
    private RowMeta rowMeta;
    private String sql;
    private String routeKey;
    private Map<String, ArrayList<Object[]>> batchDataMap = null;
    private int batchSize = 5000;
    private int totalBatchSize = 50000;
    private int count;
    private String[] groupFields;
    private int[] groupFieldIndexes;
    private Set<Integer> excludeFieldIndexSet;
    private boolean groupFieldShardingHint;
    private String shardingHintTableName;
    private Map<String, HintCondition[]> shardingHintCache = null;

    public XDbGroupOutput(String routeKey, String sql, RowMeta rowMeta, String[] groupFields, String[] excludeFields) {
        this(routeKey, sql, rowMeta, groupFields, excludeFields, false, null);
    }

    public XDbGroupOutput(String routeKey, String sql, RowMeta rowMeta, String[] groupFields, String[] excludeFields, boolean groupFieldShardingHint, String shardingHintTableName) {
        this.rowMeta = rowMeta;
        this.sql = sql;
        this.routeKey = routeKey;
        this.groupFields = groupFields;
        this.groupFieldIndexes = this.initGroupFieldIndexes(groupFields);
        this.excludeFieldIndexSet = this.initExcludeFieldIndexes(excludeFields);
        this.groupFieldShardingHint = groupFieldShardingHint;
        this.shardingHintTableName = shardingHintTableName;
    }

    private int[] initGroupFieldIndexes(String[] groupFields) {
        if (groupFields == null || groupFields.length == 0) {
            throw new KDBizException("groupFields should not be empty");
        }
        int[] tmpGroupFieldIndexes = new int[groupFields.length];
        for (int i = 0; i < groupFields.length; ++i) {
            String field = groupFields[i];
            int index = this.rowMeta.getFieldIndex(field);
            if (index < 0) {
                throw new KDBizException(String.format("field %s is not in rowMeta", field));
            }
            tmpGroupFieldIndexes[i] = index;
        }
        return tmpGroupFieldIndexes;
    }

    private Set<Integer> initExcludeFieldIndexes(String[] excludeFields) {
        if (excludeFields == null || excludeFields.length == 0) {
            return null;
        }
        HashSet<Integer> tmpExcludeFieldIndexSet = new HashSet<Integer>(excludeFields.length * 2);
        for (int i = 0; i < excludeFields.length; ++i) {
            String field = excludeFields[i];
            int index = this.rowMeta.getFieldIndex(field, false);
            if (index < 0) continue;
            tmpExcludeFieldIndexSet.add(index);
        }
        return tmpExcludeFieldIndexSet;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return false;
    }

    public void open() {
        this.batchDataMap = new HashMap<String, ArrayList<Object[]>>(256);
        if (this.groupFieldShardingHint) {
            this.shardingHintCache = new HashMap<String, HintCondition[]>(256);
        }
    }

    public void write(Object[] row) {
        ++this.count;
        String groupKey = this.groupKey(row);
        if (this.groupFieldShardingHint) {
            this.cacheShardingHintCondition(groupKey, row);
        }
        ArrayList list = this.batchDataMap.computeIfAbsent(groupKey, k -> new ArrayList(this.batchSize));
        list.add(this.filterRow(row));
        if (this.count == this.totalBatchSize || list.size() == this.batchSize) {
            this.doWrite();
        }
    }

    private void doWrite() {
        this.batchDataMap.forEach((groupKey, list) -> {
            if (!list.isEmpty()) {
                if (this.groupFieldShardingHint) {
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.shardingHintTableName, (HintCondition[])this.shardingHintCache.get(groupKey));){
                        DB.executeBatch((DBRoute)DBRoute.of((String)this.routeKey), (String)this.sql, (List)list);
                    }
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)this.routeKey), (String)this.sql, (List)list);
                }
                list.clear();
            }
        });
        this.count = 0;
    }

    public void close() {
        if (this.count > 0) {
            this.doWrite();
        }
    }

    private void cacheShardingHintCondition(String groupKey, Object[] row) {
        if (this.shardingHintCache.containsKey(groupKey)) {
            return;
        }
        HintCondition[] hintConditions = new HintCondition[this.groupFields.length];
        for (int i = 0; i < this.groupFields.length; ++i) {
            hintConditions[i] = new HintCondition("f" + this.groupFields[i], FilterType.eq, row[this.groupFieldIndexes[i]]);
        }
        this.shardingHintCache.put(groupKey, hintConditions);
    }

    private Object[] filterRow(Object[] row) {
        if (this.excludeFieldIndexSet == null || this.excludeFieldIndexSet.isEmpty()) {
            return row;
        }
        Object[] newRow = new Object[row.length - this.excludeFieldIndexSet.size()];
        int count = 0;
        for (int i = 0; i < row.length; ++i) {
            if (this.excludeFieldIndexSet.contains(i)) continue;
            newRow[count++] = row[i];
        }
        return newRow;
    }

    private String groupKey(Object[] row) {
        CharSequence[] values = new String[this.groupFieldIndexes.length];
        for (int i = 0; i < this.groupFieldIndexes.length; ++i) {
            values[i] = this.formatValue(row[this.groupFieldIndexes[i]]);
        }
        return String.join((CharSequence)"_", values);
    }

    private String formatValue(Object value) {
        if (value != null) {
            if (value instanceof String || value instanceof Long || value instanceof Integer) {
                return value.toString();
            }
            if (value instanceof Date) {
                Date dateValue = (Date)value;
                return String.valueOf(dateValue.getTime());
            }
            return value.toString();
        }
        return "";
    }
}

