/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.algox;

import java.util.ArrayList;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class XDbOutput
implements CustomizedOutput {
    private static final long serialVersionUID = 1553432677433L;
    private RowMeta rowMeta;
    private String sql;
    private String routeKey;
    private ArrayList<Object[]> batchData = null;
    private int batchSize = 5000;
    private int count;

    public XDbOutput(String routeKey, String sql, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.sql = sql;
        this.routeKey = routeKey;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return false;
    }

    public void open() {
        this.batchData = new ArrayList(this.batchSize);
    }

    public void write(Object[] row) {
        ++this.count;
        this.batchData.add(row);
        if (this.count == this.batchSize) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.routeKey), (String)this.sql, this.batchData);
            this.count = 0;
            this.batchData.clear();
        }
    }

    public void close() {
        if (this.count > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.routeKey), (String)this.sql, this.batchData);
            this.count = 0;
            this.batchData.clear();
        }
    }
}

