/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class CtrlUnitUseOrg {
    private static final int showSize = 20;
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String ORG_ENTITY = "bos_org";
    private final String entityNumber;
    private Map<Long, String> allUseOrg = null;
    private HasPermOrgResult permOrg = null;

    public CtrlUnitUseOrg(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public static CtrlUnitUseOrg create(String entityNumber) {
        return new CtrlUnitUseOrg(entityNumber);
    }

    public String getDefaultUseOrg() {
        Set<Long> allOrgIds = this.getAllUseOrgIds();
        if (CollectionUtils.isEmpty(allOrgIds)) {
            return "";
        }
        long loginOrg = RequestContext.get().getOrgId();
        if (allOrgIds.contains(loginOrg)) {
            return String.valueOf(loginOrg);
        }
        return String.valueOf(allOrgIds.iterator().next());
    }

    public String getComboItems(String defaultOrg, List<ComboItem> combos, List<Object> selectedOrgIds) {
        ArrayList<String> orgNames = new ArrayList<String>(21);
        int selectOrgSize = selectedOrgIds.size();
        HashSet<String> comboIds = new HashSet<String>(20);
        boolean eachFinish = false;
        for (Map.Entry<Long, String> entry : this.getAllUseOrg().entrySet()) {
            String orgId = String.valueOf(entry.getKey());
            String name = entry.getValue();
            if (combos.size() < 20) {
                comboIds.add(orgId);
                combos.add(new ComboItem(new LocaleString(name), orgId));
            }
            if (selectOrgSize == 0) {
                if (StringUtils.isNotBlank((CharSequence)defaultOrg) && defaultOrg.equals(orgId)) {
                    orgNames.add(name);
                    if (!comboIds.contains(orgId)) {
                        combos.add(new ComboItem(new LocaleString(name), orgId));
                    }
                    eachFinish = true;
                }
            } else if (selectOrgSize == 1) {
                if (selectedOrgIds.contains(orgId)) {
                    orgNames.add(name);
                    if (!comboIds.contains(orgId)) {
                        combos.add(new ComboItem(new LocaleString(name), orgId));
                    }
                    eachFinish = true;
                }
            } else {
                int size;
                if (selectedOrgIds.contains(orgId)) {
                    orgNames.add(name);
                    if (!comboIds.contains(orgId)) {
                        combos.add(new ComboItem(new LocaleString(name), orgId));
                    }
                }
                if ((size = orgNames.size()) >= 20 || size >= selectedOrgIds.size()) {
                    if (size >= 20) {
                        orgNames.add("...");
                    }
                    eachFinish = true;
                }
            }
            if (!eachFinish || combos.size() < 20) continue;
            break;
        }
        return String.join((CharSequence)",", orgNames);
    }

    public Set<Long> getAllUseOrgIds() {
        return this.getAllUseOrg().keySet();
    }

    private Map<Long, String> getAllUseOrg() {
        if (this.allUseOrg == null) {
            HasPermOrgResult result = this.getPermOrg();
            if (result == null) {
                return Collections.emptyMap();
            }
            this.allUseOrg = this.getAllUseOrg(result);
        }
        return this.allUseOrg;
    }

    public HasPermOrgResult getPermOrg() {
        if (this.permOrg == null) {
            long userId = RequestContext.get().getCurrUserId();
            String appId = "RPHRHCNZ0Z2";
            this.permOrg = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)this.entityNumber, (String)QUERY_PERM);
        }
        return this.permOrg;
    }

    private Map<Long, String> getAllUseOrg(HasPermOrgResult result) {
        QFilter extendOrgFilter;
        IBaseDataCtrlPlugin baseDataCtrlPlugin;
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)this.entityNumber);
        Long viewId = null == ctrlView ? 16L : ctrlView.getLong("id");
        QFilter structureFilter = new QFilter("bos_org_structure.view", "=", (Object)viewId);
        structureFilter.and(new QFilter("bos_org_structure.isctrlunit", "=", (Object)Boolean.TRUE));
        structureFilter.and("bos_org_structure.enable", "=", (Object)Boolean.TRUE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(QFilter.join((String)"id", (String)"bos_org_structure.org"));
        filters.add(structureFilter);
        if (!result.hasAllOrgPerm()) {
            filters.add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
        }
        if ((baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)this.entityNumber)) != null && null != (extendOrgFilter = baseDataCtrlPlugin.getExtendOrgQFilter())) {
            filters.add(extendOrgFilter);
        }
        LinkedHashMap<Long, String> orgNameMap = new LinkedHashMap<Long, String>(16);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), ORG_ENTITY, "id, name", filters.toArray(new QFilter[0]), "id");){
            for (Row row : ds) {
                Long orgId = row.getLong("id");
                if (null == orgId) continue;
                orgNameMap.put(orgId, row.getString("name"));
            }
        }
        return orgNameMap;
    }

    public QFilter getBaseDataFilter() {
        return BaseDataServiceHelper.getBaseDataFilter((String)this.entityNumber, new ArrayList<Long>(this.getAllUseOrgIds()), (boolean)true);
    }
}

