/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.DefaultFilterValueSetter;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.IFilterValueSetter;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.pa.cost.DimensionTypeEnum;
import kd.fi.pa.cost.EntryTreeNode;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.dto.DateRangeDTO;
import kd.fi.pa.utils.PAUtil;

public class CvprofitBusinessHelper {
    public static final String appId_1 = "faf";
    public static final String appId_2 = "pa";
    public static final String PERM_FORMID = "faf_data_query";

    public static Set<Long> getMergePermOrgs() {
        long currUserId = RequestContext.get().getCurrUserId();
        return CvprofitBusinessHelper.getMergePermOrgs(currUserId);
    }

    public static Set<Long> getMergePermOrgs(long userId) {
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return CvprofitBusinessHelper.getAllUnitOrgIds();
        }
        HasPermOrgResult hasPermOrgs_1 = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)AppMetadataCache.getAppInfo((String)appId_1).getId(), (String)PERM_FORMID, (String)"47150e89000000ac", (boolean)true);
        List hasPermOrgs = hasPermOrgs_1.getHasPermOrgs();
        HasPermOrgResult hasPermOrg_2 = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)AppMetadataCache.getAppInfo((String)appId_2).getId(), (String)PERM_FORMID, (String)"47150e89000000ac", (boolean)true);
        hasPermOrgs.addAll(hasPermOrg_2.getHasPermOrgs());
        return new HashSet<Long>(hasPermOrgs);
    }

    public static Set<Long> getAllUnitOrgIds() {
        return new HashSet<Long>(OrgUnitServiceHelper.getAllOrg((String)"15"));
    }

    public static EntryTreeNode buildTreeNode(DynamicObjectCollection datas) {
        EntryTreeNode root = new EntryTreeNode();
        LinkedHashMap<Long, EntryTreeNode> nodeMap = new LinkedHashMap<Long, EntryTreeNode>(datas.size());
        nodeMap.put(root.getId(), root);
        for (int i = 0; i < datas.size(); ++i) {
            DynamicObject entry = (DynamicObject)datas.get(i);
            EntryTreeNode node = new EntryTreeNode(entry);
            node.setIndex(i);
            nodeMap.put(node.getId(), node);
        }
        Collection values = nodeMap.values();
        for (EntryTreeNode node : values) {
            EntryTreeNode treeNode;
            if (node == root || (treeNode = (EntryTreeNode)nodeMap.get(node.getPid())) == null) continue;
            treeNode.appendChildren(node);
        }
        return root;
    }

    public static List<Map<String, Object>> formulaEntryToMapList(DynamicObjectCollection entryEntity) {
        ArrayList<Map<String, Object>> entryMap = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : entryEntity) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("lb", dynamicObject.getString("lb"));
            map.put("rb", dynamicObject.getString("rb"));
            map.put("dt", dynamicObject.getString("dt"));
            map.put("df", dynamicObject.getString("df"));
            map.put("m", dynamicObject.getLong("m_id"));
            map.put("v", dynamicObject.getBigDecimal("v"));
            map.put("op", dynamicObject.getString("op"));
            entryMap.add(map);
        }
        return entryMap;
    }

    public static Long queryModelBySchema(Object pkvalue) {
        Long modelid;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"pa_cvprofitschema", (String)"model.id", (QFilter[])new QFilter("id", "=", pkvalue).toArray());
        if (dynamicObject != null && PAUtil.idNotNull((Object)(modelid = Long.valueOf(dynamicObject.getLong("model.id"))))) {
            return modelid;
        }
        return null;
    }

    public static Set<Long> queryNotDateTimeModelSet() {
        QFilter filter = new QFilter("analysis_system.number", "is not null", null).and("tablenumber", "!=", (Object)Character.valueOf(' ')).and("tablenumber", "is not null", null).and("enable", "=", (Object)Character.valueOf('1')).and("dimension_entry.necessity_dim", "=", (Object)"1").and("dimension_entry.dimension.dimensionsource", "in", (Object)new String[]{"bd_period", "pa_analysisperiod"});
        HashSet<Long> set = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryNotDateTimeModelSet", (String)"pa_analysismodel", (String)"id,number", (QFilter[])filter.toArray(), null);){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
            }
        }
        return set;
    }

    public static QFilter getQFilterByDimension(DynamicObject dimension) {
        if (dimension == null) {
            return null;
        }
        String dimensiontype = dimension.getString("dimensiontype");
        if (DimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            String grouptype = dimension.getString("typefield");
            Object group_id = dimension.get("group_id");
            if (StringUtils.isNotEmpty((CharSequence)grouptype) && group_id != null) {
                QFilter qFilter = new QFilter(grouptype, "=", group_id);
                return qFilter;
            }
            return null;
        }
        if (DimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            DynamicObject assistant = dimension.getDynamicObject("assistantsource");
            return new QFilter("group", "=", assistant.getPkValue());
        }
        return null;
    }

    public static List<ValueMapItem> getValueMapItems(DynamicObject dimension) {
        DynamicObject dynObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension.getPkValue(), (String)"pa_dimension");
        DynamicObjectCollection items = dynObject.getDynamicObjectCollection("entryentityenums");
        return items.stream().map(dyn -> new ValueMapItem(null, dyn.getString("value"), new LocaleString(dyn.getString("title")))).collect(Collectors.toList());
    }

    public static Class<?> getDimensionPrimaryKeyType(DynamicObject dimension) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (DimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            Object dimensionsource = dimension.getDynamicObject("dimensionsource").getPkValue();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((String)dimensionsource));
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (primaryKey instanceof VarcharProp) {
                return String.class;
            }
            return Long.class;
        }
        if (DimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            return Long.class;
        }
        if (DimensionTypeEnum.OTHER.eqScene((Object)dimensiontype)) {
            return String.class;
        }
        if (DimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
            return String.class;
        }
        if (DimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
            return Date.class;
        }
        return String.class;
    }

    public static Object covertTypeTo(String name, Class<?> primaryKeyType, Object o) {
        if (primaryKeyType == Long.class) {
            if (o instanceof Long) {
                return o;
            }
            try {
                return Long.parseLong(String.valueOf(o));
            }
            catch (Exception ex) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570[%s]\u5165\u53c2\u7c7b\u578b\u9519\u8bef\u3002", (String)"CvprofitBusinessHelper_0", (String)"fi-pa-business", (Object[])new Object[0]), name));
            }
        }
        if (primaryKeyType == Date.class) {
            return DateRangeDTO.toDate((String)String.valueOf(o));
        }
        return String.valueOf(o);
    }

    public static void bindSnapshootInfo(IDataModel model, CvprofitQueryParam queryParam) {
        model.beginInit();
        model.setValue("model", (Object)queryParam.getModelId());
        Set<Long> orgsetid = queryParam.getOrgsetId();
        model.setValue("orgset", (Object)orgsetid.toArray());
        model.setValue("periodentity", (Object)queryParam.getPeriodentity());
        model.setValue("period", (Object)queryParam.getPeriodId());
        model.setValue("dimension", (Object)queryParam.getDimensionId());
        model.setValue("dimensionmembertxt", (Object)queryParam.getDimensionmember());
        model.setValue("dimensionmember", (Object)queryParam.getDimensionmember());
        model.setValue("dimensionmember_TAG", (Object)queryParam.getDimensionmember_tag());
        model.setDataChanged(false);
        model.endInit();
    }

    public static QFilter getIndexModelSimpleQFilter(String entityNumber, String conditionJson) {
        try {
            if (StringUtils.isEmpty((CharSequence)conditionJson)) {
                return null;
            }
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                int charIndex = fieldName.indexOf(46);
                if (charIndex <= -1) continue;
                simpleFilterRow.setFieldName(fieldName.substring(0, charIndex));
                if (!"9".equals(simpleFilterRow.getCompareType())) continue;
                simpleFilterRow.setCompareType("83");
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)"0");
                simpleFilterRow.setValue(Collections.singletonList(filterValue));
            }
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition, (IFilterValueSetter)new DefaultFilterValueSetter(){

                public List<Object> getFieldValue(SimpleFilterRow simpleFilterRow) {
                    List baseDataIds = simpleFilterRow.getBaseDataIds();
                    if (baseDataIds.isEmpty()) {
                        return new DefaultFilterValueSetter().getFieldValue(simpleFilterRow);
                    }
                    return simpleFilterRow.getBaseDataIds().stream().map(FilterValue::getValue).collect(Collectors.toList());
                }
            }, true, null);
            filterBuilder.buildFilter(false);
            return filterBuilder.getQFilter();
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6790\u65b9\u6848\u7684\u201d\u5206\u6790\u6a21\u578b\u53d6\u503c\u201c\uff0c\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u914d\u7f6e\u9519\u8bef\u3002", (String)"CvprofitBusinessHelper_1", (String)"fi-pa-business", (Object[])new Object[0]));
        }
    }

    public static QFilter parseToQFilter(DynamicObject dimension, String filterTag) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (DimensionTypeEnum.OTHER.eqScene((Object)dimensiontype)) {
            String[] split = filterTag.split("\n");
            HashSet<String> set = new HashSet<String>(Arrays.asList(split));
            return new QFilter(dimension.getString("number"), "in", set);
        }
        Set<String> objSet = CvprofitBusinessHelper.parseTagToSet(filterTag);
        if (DimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype) || DimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            Class<?> primaryKeyType = CvprofitBusinessHelper.getDimensionPrimaryKeyType(dimension);
            Object[] collect = objSet.stream().map(o -> CvprofitBusinessHelper.covertTypeTo(dimension.getString("name"), primaryKeyType, o)).toArray();
            return new QFilter(dimension.getString("number"), "in", (Object)collect);
        }
        if (DimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
            return new QFilter(dimension.getString("number"), "in", objSet);
        }
        if (DimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
            return CvprofitBusinessHelper.createBetweenAndQFilter(dimension, filterTag);
        }
        return null;
    }

    private static Set<String> parseTagToSet(String tag) {
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            String[] split = tag.split(",");
            return Arrays.stream(split).filter(s -> !"".equals(s)).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private static QFilter createBetweenAndQFilter(DynamicObject dimension, String variable) {
        if (variable == null) {
            return null;
        }
        String startDate = null;
        String endDate = null;
        String[] objs = variable.split(",");
        if (objs.length > 0 && objs[0] != null) {
            startDate = objs[0];
        }
        if (objs.length > 1 && objs[1] != null) {
            endDate = objs[1];
        }
        DateRangeDTO dateRange = new DateRangeDTO(startDate, endDate);
        return PAUtil.timeSection((String)dimension.getString("number"), (DateRangeDTO)dateRange);
    }
}

