/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;

public class EntryTreeNode {
    private final int seq;
    private final List<EntryTreeNode> children = new ArrayList<EntryTreeNode>();
    private Long id;
    private Long pid;
    private int level = 0;
    private Long preBrotherId;
    private DynamicObject data;
    private int index = -1;
    private EntryTreeNode parent;

    public EntryTreeNode() {
        this.id = 0L;
        this.seq = 0;
        this.level = 0;
    }

    public EntryTreeNode(DynamicObject entry) {
        this.id = entry.getLong("id");
        this.pid = entry.getLong("pid");
        this.seq = entry.getInt("seq");
        this.data = entry;
    }

    public EntryTreeNode getParent() {
        return this.parent;
    }

    public void setParent(EntryTreeNode parent) {
        this.pid = parent.getId();
        this.parent = parent;
        this.level = parent.getLevel() + 1;
    }

    public List<EntryTreeNode> getChildren() {
        return this.children;
    }

    public List<EntryTreeNode> getList() {
        return new ArrayList<EntryTreeNode>();
    }

    public EntryTreeNode getNode(Long id) {
        if (id == null) {
            return null;
        }
        if (Objects.equals(id, this.id)) {
            return this;
        }
        for (EntryTreeNode child : this.children) {
            EntryTreeNode node = child.getNode(id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public EntryTreeNode getNode(Integer index) {
        if (Objects.equals(index, this.index)) {
            return this;
        }
        for (EntryTreeNode child : this.children) {
            EntryTreeNode node = child.getNode(index);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void appendChildren(EntryTreeNode node) {
        node.setParent(this);
        List<EntryTreeNode> brothers = this.getChildren();
        if (!brothers.isEmpty()) {
            EntryTreeNode brotherNode = brothers.get(brothers.size() - 1);
            node.setPreBrotherId(brotherNode.getId());
        }
        brothers.add(node);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPid() {
        return this.pid;
    }

    public int getSeq() {
        return this.seq;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getLevel() {
        return this.level;
    }

    public Long getPreBrotherId() {
        return this.preBrotherId;
    }

    public void setPreBrotherId(Long preBrotherId) {
        this.preBrotherId = preBrotherId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryTreeNode treeNode = (EntryTreeNode)o;
        return Objects.equals(this.id, treeNode.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Node {id=" + this.id + ", pid=" + this.pid + ", index=" + this.index + ", pindex=" + (this.parent == null ? -1 : this.parent.getIndex()) + '}';
    }

    public int getRowCount() {
        int count = 1;
        for (EntryTreeNode child : this.children) {
            count += child.getRowCount();
        }
        return count;
    }

    public void reSort() {
        List<EntryTreeNode> nodes = this.getNodes(false);
        for (int i = 0; i < nodes.size(); ++i) {
            nodes.get(i).setIndex(i);
        }
    }

    public List<EntryTreeNode> getNodes(boolean includeSelf) {
        ArrayList<EntryTreeNode> nodes = new ArrayList<EntryTreeNode>();
        if (includeSelf) {
            nodes.add(this);
        }
        for (EntryTreeNode child : this.children) {
            nodes.addAll(child.getNodes());
        }
        return nodes;
    }

    public List<EntryTreeNode> getNodes() {
        return this.getNodes(true);
    }

    public int[] getAllNodeRows() {
        return this.getNodes().stream().mapToInt(EntryTreeNode::getIndex).toArray();
    }

    public DynamicObject getData() {
        return this.data;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean notLeaf() {
        return !this.isLeaf();
    }

    public boolean isRoot() {
        return Objects.equals(this.id, 0L);
    }

    public int getMaxLevel() {
        int maxLevel = this.level;
        List<EntryTreeNode> nodes = this.getNodes(false);
        for (EntryTreeNode node : nodes) {
            maxLevel = Math.max(maxLevel, node.getLevel());
        }
        return maxLevel;
    }

    public boolean filled() {
        return this.data != null && (StringUtils.isNotEmpty((CharSequence)this.data.getString("attribute")) || StringUtils.isNotEmpty((CharSequence)this.data.getString("evaluation")) || this.data.getBigDecimal("fixedvalue") != null);
    }
}

