/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.EntryTreeNode;

public class EntryTreeOperater {
    private final String controlKey;
    private final IFormView view;
    private final long[] selectRowIds;
    private final TreeEntryGrid control;
    private EntryTreeNode root;
    private Set<String> clearSet;

    public EntryTreeOperater(IFormView view, String controlKey) {
        this.controlKey = controlKey;
        this.view = view;
        this.loadData();
        this.control = (TreeEntryGrid)view.getControl(controlKey);
        int[] selectRows = this.control.getSelectRows();
        this.selectRowIds = new long[selectRows.length];
        for (int i = 0; i < selectRows.length; ++i) {
            this.selectRowIds[i] = view.getModel().getEntryRowEntity(controlKey, selectRows[i]).getLong("id");
        }
    }

    private void loadData() {
        DynamicObjectCollection datas = this.view.getModel().getEntryEntity(this.controlKey);
        this.root = CvprofitBusinessHelper.buildTreeNode(datas);
    }

    private boolean onlySelectOne() {
        if (this.selectRowIds.length == 1) {
            return true;
        }
        if (this.selectRowIds.length == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EntryTreeOperater_0", (String)"fi-pa-business", (Object[])new Object[0]));
            return false;
        }
        this.view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EntryTreeOperater_4", (String)"fi-pa-business", (Object[])new Object[0]));
        return false;
    }

    private void insertEntryRow(EntryTreeNode self, int offset) {
        IDataModel model = this.view.getModel();
        int[] ints = model.appendEntryRow(this.controlKey, self.getIndex() + offset - 1, self.getRowCount());
        List<EntryTreeNode> nodes = self.getNodes();
        for (int i = 0; i < ints.length; ++i) {
            long pid;
            EntryTreeNode node = nodes.get(i);
            int rowIndex = ints[i];
            EntryTreeNode pNode = node.getParent();
            if (pNode.isRoot()) {
                pid = 0L;
            } else if (Objects.equals(self, node)) {
                pid = self.getPid();
            } else {
                int prowIndex = pNode.getIndex() + offset;
                pid = model.getEntryRowEntity(this.controlKey, prowIndex).getLong("id");
            }
            model.setValue("pid", (Object)pid, rowIndex);
            model.setValue("reportitem", node.getData().get("reportitem"), rowIndex);
            for (String entryField : this.getEntryFields()) {
                model.setValue(entryField, node.getData().get(entryField), rowIndex);
            }
            model.setValue("remark", node.getData().get("remark"), rowIndex);
        }
    }

    private void focusRows(int pRowIndex, int index) {
        if (pRowIndex < 0) {
            pRowIndex = index;
        }
        this.control.focus(pRowIndex, index);
        this.control.selectRows(index);
        this.view.getModel().setEntryCurrentRowIndex(this.controlKey, index);
    }

    public EntryTreeNode getPreBrotherNode() {
        if (this.onlySelectOne()) {
            long selectRowId = this.selectRowIds[0];
            EntryTreeNode node = this.root.getNode(selectRowId);
            Long preBrotherId = node.getPreBrotherId();
            return this.root.getNode(preBrotherId);
        }
        return null;
    }

    public EntryTreeNode getSelectNode() {
        if (this.onlySelectOne()) {
            long selectRowId = this.selectRowIds[0];
            return this.root.getNode(selectRowId);
        }
        return null;
    }

    public boolean cancelInsertentry() {
        if (this.onlySelectOne()) {
            long selectRowId = this.selectRowIds[0];
            EntryTreeNode node = this.root.getNode(selectRowId);
            int level = node.getLevel();
            if (level < 3) {
                return false;
            }
            this.view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u6700\u591a\u652f\u63013\u5c42\u3002", (String)"EntryTreeOperater_1", (String)"fi-pa-business", (Object[])new Object[0]));
            return true;
        }
        return true;
    }

    public boolean cancelDownlevelentity() {
        if (this.onlySelectOne()) {
            long selectRowId = this.selectRowIds[0];
            EntryTreeNode self = this.root.getNode(selectRowId);
            Long preBrotherId = self.getPreBrotherId();
            if (preBrotherId == null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8282\u70b9\u4e3a\u540c\u5c42\u7ea7\u4e0b\u7684\u9996\u4e2a\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u964d\u7ea7\u3002", (String)"EntryTreeOperater_3", (String)"fi-pa-business", (Object[])new Object[0]));
                return true;
            }
            int maxlevel = self.getMaxLevel();
            if (maxlevel >= 3) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u6700\u591a\u652f\u63013\u5c42\u3002", (String)"EntryTreeOperater_1", (String)"fi-pa-business", (Object[])new Object[0]));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean containNotLeaf() {
        for (long selectRowId : this.selectRowIds) {
            EntryTreeNode self = this.root.getNode(selectRowId);
            if (self.isLeaf()) continue;
            return true;
        }
        return false;
    }

    public void deleteentry() {
        LinkedHashSet<Integer> rows = new LinkedHashSet<Integer>();
        for (long selectRowId : this.selectRowIds) {
            EntryTreeNode self = this.root.getNode(selectRowId);
            if (self == null) {
                return;
            }
            List<EntryTreeNode> nodes = self.getNodes();
            for (int i = nodes.size() - 1; i >= 0; --i) {
                rows.add(nodes.get(i).getIndex());
            }
        }
        IDataModel model = this.view.getModel();
        model.beginInit();
        int[] array = rows.stream().mapToInt(Integer::intValue).toArray();
        model.deleteEntryRows(this.controlKey, array);
        model.endInit();
        this.refresh();
    }

    public void uplevel() {
        if (this.onlySelectOne()) {
            EntryTreeNode self = this.root.getNode(this.selectRowIds[0]);
            if (self == null) {
                return;
            }
            EntryTreeNode parent = this.root.getNode(self.getPid());
            if (parent == this.root) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5347\u7ea7\u3002", (String)"EntryTreeOperater_2", (String)"fi-pa-business", (Object[])new Object[0]));
                return;
            }
            parent.getChildren().remove(self);
            EntryTreeNode pparent = parent.getParent();
            List<EntryTreeNode> children = pparent.getChildren();
            int indexOf = children.indexOf(parent);
            children.add(indexOf + 1, self);
            self.setParent(pparent);
            IDataModel model = this.view.getModel();
            int[] selfAllNodeRows = self.getAllNodeRows();
            model.deleteEntryRows(this.controlKey, selfAllNodeRows);
            this.root.reSort();
            this.insertEntryRow(self, 0);
            this.refresh();
            this.focusRows(self.getParent().getIndex(), self.getIndex());
        }
    }

    public void downlevel() {
        if (this.onlySelectOne()) {
            EntryTreeNode self = this.root.getNode(this.selectRowIds[0]);
            if (self == null) {
                return;
            }
            Long preBrotherId = self.getPreBrotherId();
            self.setParent(this.root.getNode(preBrotherId));
            this.view.getModel().setValue("pid", (Object)preBrotherId, self.getIndex());
            this.refresh();
            this.focusRows(self.getParent().getIndex(), self.getIndex());
        }
    }

    public void copyentryrow() {
        if (this.onlySelectOne()) {
            EntryTreeNode self = this.root.getNode(this.selectRowIds[0]);
            this.insertEntryRow(self, self.getRowCount());
            this.refresh();
            this.focusRows(self.getParent().getIndex() + self.getRowCount(), self.getIndex() + self.getRowCount());
        }
    }

    public Set<String> getEntryFields() {
        if (this.clearSet == null) {
            this.clearSet = new HashSet<String>();
            this.clearSet.add("attribute");
            this.clearSet.add("evaluation");
            this.clearSet.add("evaluation_tag");
            this.clearSet.add("fixedvalue");
        }
        return this.clearSet;
    }

    public void refresh() {
        this.view.getModel().updateCache();
        this.loadData();
        this.clearAndLock();
        this.view.updateView(this.controlKey);
    }

    public void clearAndLock() {
        List<EntryTreeNode> nodes = this.root.getNodes(false);
        IDataModel model = this.view.getModel();
        for (EntryTreeNode node : nodes) {
            if (node.isLeaf()) continue;
            int rowIndex = node.getIndex();
            for (String entryField : this.getEntryFields()) {
                model.setValue(entryField, null, rowIndex);
            }
        }
        this.lock(nodes);
    }

    public void refreshLock() {
        this.lock(this.root.getNodes(false));
    }

    public void lock(List<EntryTreeNode> nodes) {
        for (EntryTreeNode node : nodes) {
            if (!node.isLeaf()) {
                this.view.setEnable(Boolean.FALSE, node.getIndex(), new String[]{"attribute", "fixedvalue"});
                continue;
            }
            this.view.setEnable(Boolean.TRUE, node.getIndex(), new String[]{"attribute", "fixedvalue"});
        }
    }

    public void expandAll() {
        int[] array = this.root.getNodes().stream().filter(EntryTreeNode::notLeaf).mapToInt(EntryTreeNode::getIndex).toArray();
        this.control.expand(array);
    }
}

