/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost.data;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.cost.data.DynamicData;

public class CvprofitModel
extends DynamicData {
    private static final long serialVersionUID = -3427836709756664553L;
    private final Map<String, String> dimensionsMap;
    private String entityname;
    private String orgFieldNumber = "";
    private String periodFieldNumber = "";
    private String periodEntityName = "";
    private Object periodtypeID;
    private String accountFieldNumber = "";

    public CvprofitModel(DynamicObject dynamic) {
        super(dynamic);
        DynamicObjectCollection entry = dynamic.getDynamicObjectCollection("dimension_entry");
        this.dimensionsMap = new LinkedHashMap<String, String>();
        for (DynamicObject dyn : entry) {
            DynamicObject dimension = dyn.getDynamicObject("dimension");
            String number = dimension.getString("number");
            String name = dimension.getString("name");
            this.dimensionsMap.put(number, name);
            String necessity = dyn.getString("necessity_dim");
            if ("0".equals(necessity)) {
                this.orgFieldNumber = number;
            }
            if ("1".equals(necessity)) {
                this.periodFieldNumber = number;
                this.periodEntityName = dimension.getString("dimensionsource.number");
                this.periodtypeID = dimension.get("group_id");
            }
            if (!"2".equals(necessity)) continue;
            this.accountFieldNumber = number;
        }
    }

    public static CvprofitModel create(Object pkvalue) {
        if (pkvalue == null) {
            throw new KDBizException("model pkvalue is null");
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_analysismodel");
        return new CvprofitModel(dynamicObject);
    }

    public String getEntitynumber() {
        if (StringUtils.isEmpty((CharSequence)this.entityname)) {
            String tablenumber = this.dynamic.getString("tablenumber");
            if (StringUtils.isEmpty((CharSequence)tablenumber)) {
                throw new KDBizException(new ErrorCode("ErrorNotification", ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\u3002", (String)"CvprofitModel_0", (String)"fi-pa-business", (Object[])new Object[0])), new Object[0]);
            }
            this.entityname = "pa_" + tablenumber;
        }
        return this.entityname;
    }

    public String getOrgNumber() {
        return this.orgFieldNumber;
    }

    public String getPeriodNumber() {
        return this.periodFieldNumber;
    }

    public String getPeriodEntityName() {
        return this.periodEntityName;
    }

    public String getAccountFieldNumber() {
        return this.accountFieldNumber;
    }

    public Object getPeriodtypeID() {
        return this.periodtypeID;
    }

    public Map<String, String> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public DynamicObject getDimension(Object pkvalue) {
        DynamicObjectCollection collection = this.dynamic.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : collection) {
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            if (!Objects.equals(pkvalue, dimension.getPkValue())) continue;
            return dimension;
        }
        return null;
    }

    public DynamicObject getDimension(String number) {
        DynamicObjectCollection collection = this.dynamic.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : collection) {
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            if (!Objects.equals(number, dimension.getString("number"))) continue;
            return dimension;
        }
        return null;
    }

    public Set<Object> getOrdinaryDimensionSet() {
        DynamicObjectCollection entry = this.dynamic.getDynamicObjectCollection("dimension_entry");
        return entry.stream().filter(dyn -> {
            String necessity = dyn.getString("necessity_dim");
            return !"0".equals(necessity) && !"1".equals(necessity);
        }).map(dynamicObject -> dynamicObject.getDynamicObject("dimension").getPkValue()).collect(Collectors.toSet());
    }
}

