/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.cost.CvprofitDataSourceTypeEnum;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.cost.data.DynamicData;
import kd.fi.pa.cost.formula.Factor;
import kd.fi.pa.cost.formula.Formula;
import kd.fi.pa.utils.PAUtil;

public class CvprofitSchema
extends DynamicData {
    private static final long serialVersionUID = -3145143318092287767L;

    public CvprofitSchema(DynamicObject dynamic) {
        super(dynamic);
    }

    public static CvprofitSchema create(Object pkvalue) {
        if (pkvalue == null) {
            throw new KDBizException("schema pkvalue is null");
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_cvprofitschema");
        return new CvprofitSchema(dynamicObject);
    }

    public Map<String, ?> exec(CvprofitQueryParam param) {
        LinkedHashMap<String, BigDecimal> map = new LinkedHashMap<String, BigDecimal>();
        DynamicObjectCollection collection = this.dynamic.getDynamicObjectCollection("treeentryentity");
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            String attribute = entry.getString("attribute");
            if (StringUtils.isEmpty((CharSequence)attribute)) continue;
            String datasourcetype = this.dynamic.getString("datasourcetype");
            if (CvprofitDataSourceTypeEnum.FIXED.eq((Object)datasourcetype)) {
                BigDecimal fixedvalue = entry.getBigDecimal("fixedvalue");
                this.accumulator(map, attribute, this.setScale(fixedvalue));
                continue;
            }
            String evaluation_tag = entry.getString("evaluation_tag");
            Factor factor = Formula.create(i, evaluation_tag);
            BigDecimal value = factor.calc(param);
            this.accumulator(map, attribute, this.setScale(value));
        }
        this.calcAvgValue(map);
        return map;
    }

    private BigDecimal setScale(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(2, RoundingMode.HALF_UP);
    }

    private void accumulator(Map<String, BigDecimal> map, String attribute, BigDecimal value) {
        BigDecimal orDefault = map.getOrDefault(attribute, BigDecimal.ZERO);
        map.put(attribute, orDefault.add(value));
    }

    private void calcAvgValue(Map<String, BigDecimal> map) {
        BigDecimal divisor = map.get("sales_volume");
        map.put("unit_variable_cost", this.safeDivide(map.get("variable_cost"), divisor));
        map.put("unit_variable_expenses", this.safeDivide(map.get("variable_expenses"), divisor));
        map.put("unit_price", this.safeDivide(map.get("income"), divisor));
    }

    private BigDecimal safeDivide(BigDecimal dividend, BigDecimal divisor) {
        if (dividend == null || divisor == null || divisor.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return dividend.divide(divisor, 2, RoundingMode.HALF_UP);
    }

    public List<String> valid(CvprofitQueryParam param) {
        String datasourcetype = this.dynamic.getString("datasourcetype");
        if (CvprofitDataSourceTypeEnum.MODEL.eq((Object)datasourcetype)) {
            ArrayList<String> list = new ArrayList<String>();
            if (CollectionUtils.isEmpty(param.getOrgsetId())) {
                list.add("orgset");
            }
            if (PAUtil.idIsNull((Object)param.getPeriodId())) {
                list.add("period");
            }
            return list;
        }
        if (CvprofitDataSourceTypeEnum.FIXED.eq((Object)datasourcetype)) {
            return Collections.emptyList();
        }
        throw new KDBizException("not support datasource type");
    }

    public String builSnapshoot(CvprofitQueryParam param, String result) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("queryParam", SerializationUtils.toJsonString((Object)param));
        String entityId = this.dynamic.getDataEntityType().getName();
        map.put("schema_entitytype", entityId);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        String serializeToString = jser.serializeToString((Object)this.dynamic, null);
        map.put("schema_map", serializeToString);
        map.put("calcResult", result);
        return SerializationUtils.toJsonString(map);
    }
}

