/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.cost.data.CvprofitModel;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.cost.formula.Factor;
import kd.fi.pa.cost.formula.SingleSymbol;
import kd.fi.pa.utils.PAUtil;

public class FindFactor
extends SingleSymbol
implements Factor {
    private static final long serialVersionUID = 7803412557528062746L;
    private final CvprofitModel model;
    private final DynamicObject measure;
    private final QFilter qFilter;

    public FindFactor(int row, CvprofitModel model, String filter, Long measureId) {
        super(row);
        this.model = model;
        if (PAUtil.idIsNull((Object)measureId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u7ef4\u5ea6\u7ec4\u5408\u6709\u503c\u65f6\uff0c\u5ea6\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FindFactor_0", (String)"fi-pa-business", (Object[])new Object[0]), row));
        }
        this.qFilter = CvprofitBusinessHelper.getIndexModelSimpleQFilter(model.getEntitynumber(), filter);
        this.measure = BusinessDataServiceHelper.loadSingleFromCache((Object)measureId, (String)"pa_measure");
    }

    public String toString() {
        return String.format("sum(%1$s)", this.measure.getString("name"));
    }

    @Override
    public BigDecimal calc(CvprofitQueryParam param) {
        ArrayList<Object> mergeQFilters = new ArrayList<Object>();
        mergeQFilters.add(this.qFilter);
        mergeQFilters.addAll(this.generatorParamQFilter(param));
        try (DataSet dataSet = ORM.create().queryDataSet("Pa_FindFactor_calc", this.model.getEntitynumber(), "sum(" + this.measure.getString("number") + ") as _sum", mergeQFilters.toArray(new QFilter[0]), null);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                BigDecimal sum = next.getBigDecimal("_sum");
                if (sum == null) {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    return bigDecimal;
                }
                BigDecimal bigDecimal = sum;
                return bigDecimal;
            }
        }
        return BigDecimal.ZERO;
    }

    private List<? extends QFilter> generatorParamQFilter(CvprofitQueryParam param) {
        try {
            String tag;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(this.model.getOrgNumber(), "in", param.getOrgsetId()));
            qFilters.add(new QFilter(this.model.getPeriodNumber(), "=", (Object)param.getPeriodId()));
            DynamicObject dimension = this.model.getDimension(param.getDimensionId());
            if (dimension != null && StringUtils.isNotEmpty((CharSequence)(tag = param.getDimensionmember_tag()))) {
                qFilters.add(CvprofitBusinessHelper.parseToQFilter(dimension, param.getDimensionmember_tag()));
            }
            return qFilters;
        }
        catch (Exception ex) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u89e3\u6790\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"FindFactor_3", (String)"fi-pa-business", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

