/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost.formula;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.LogFactory;
import kd.fi.pa.cost.data.CvprofitModel;
import kd.fi.pa.cost.data.CvprofitQueryParam;
import kd.fi.pa.cost.formula.Factor;
import kd.fi.pa.cost.formula.FigureFactor;
import kd.fi.pa.cost.formula.FindFactor;
import kd.fi.pa.cost.formula.LeftBracket;
import kd.fi.pa.cost.formula.Operation;
import kd.fi.pa.cost.formula.RightBracket;
import kd.fi.pa.cost.formula.Symbol;
import kd.fi.pa.utils.PAUtil;

public class Formula
implements Factor {
    private static final long serialVersionUID = -3893263487971568155L;
    private final List<Symbol> symbols;
    private final Factor leftFactor;
    private final Operation operation;
    private final Factor rightFactor;

    private Formula(List<Symbol> symbols) {
        this.symbols = symbols;
        if (symbols.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"Formula_0", (String)"fi-pa-business", (Object[])new Object[0]));
        }
        Operation operation = null;
        Integer opIndex = null;
        for (int pos = symbols.size() - 1; pos > 0; --pos) {
            Symbol s_pos = symbols.get(pos);
            if (s_pos instanceof Operation) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u503c\u516c\u5f0f\u4e0d\u80fd\u4ee5\u8fd0\u7b97\u7b26\u7ed3\u5c3e\u3002", (String)"Formula_1", (String)"fi-pa-business", (Object[])new Object[0]));
            }
            if (s_pos instanceof RightBracket) {
                int size;
                boolean bracketClose = false;
                int rightCount = 1;
                int leftCount = 0;
                for (int i = size = pos - 1; i >= 0; --i) {
                    Symbol spos = symbols.get(i);
                    if (spos instanceof RightBracket) {
                        ++rightCount;
                    } else if (spos instanceof LeftBracket) {
                        ++leftCount;
                    }
                    if (leftCount != rightCount) continue;
                    pos = i;
                    bracketClose = true;
                    break;
                }
                if (!bracketClose) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7b26\u53f7 \u201c)\u201d \u672a\u5c01\u95ed\u3002", (String)"Formula_2", (String)"fi-pa-business", (Object[])new Object[0]));
                }
            }
            if (--pos < 0) break;
            Symbol s_op = symbols.get(pos);
            if (s_op instanceof Operation) {
                if (operation != null) {
                    if (((Operation)s_op).getPriority() >= operation.getPriority()) continue;
                    operation = (Operation)s_op;
                    opIndex = pos;
                    continue;
                }
                operation = (Operation)s_op;
                opIndex = pos;
                continue;
            }
            Symbol symbol = symbols.get(pos + 1);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u672b\u5c3e\uff0c\u5e94\u8be5\u914d\u7f6e\u8fd0\u7b97\u7b26\u3002", (String)"Formula_3", (String)"fi-pa-business", (Object[])new Object[0]), symbol.getRow() - 1));
        }
        if (opIndex == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u503c\u516c\u5f0f\u7f3a\u5c11\u5fc5\u8981\u7684\u8fd0\u7b97\u7b26\u3002", (String)"Formula_4", (String)"fi-pa-business", (Object[])new Object[0]));
        }
        this.leftFactor = this.createSub(0, opIndex);
        this.operation = operation;
        this.rightFactor = this.createSub(opIndex + 1, symbols.size());
    }

    public static Factor create(int row, String evaluation_tag) {
        try {
            Map map = (Map)PAUtil.cast((Object)SerializationUtils.fromJsonString((String)evaluation_tag, Map.class));
            Long modelPkValue = (Long)PAUtil.cast(map.get("modelPkValue"));
            List mapList = (List)PAUtil.cast(map.get("formulaMapList"));
            return Formula.create(modelPkValue, mapList);
        }
        catch (KDBizException kdBizException) {
            LogFactory.getLog(Formula.class).error("formula create", (Throwable)kdBizException);
            throw kdBizException;
        }
        catch (Exception ex) {
            LogFactory.getLog(Formula.class).error("formula create " + row + 1, (Throwable)ex);
            throw new KDBizException(String.format("schema row %s ,create formula fail\uff0ctag is %s.", row + 1, evaluation_tag));
        }
    }

    public static String createTag(Long modelPkValue, List<Map<String, Object>> mapList) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("modelPkValue", modelPkValue);
        map.put("formulaMapList", mapList);
        return SerializationUtils.toJsonString(map);
    }

    public static Factor create(Long modelPkValue, List<Map<String, Object>> mapList) {
        CvprofitModel model = CvprofitModel.create(modelPkValue);
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (int i = 0; i < mapList.size(); ++i) {
            String operator;
            boolean isfindfactor;
            int row = i + 1;
            Map<String, Object> map = mapList.get(i);
            String leftbracket = (String)map.get("lb");
            if (leftbracket != null) {
                for (int j = 0; j < leftbracket.length(); ++j) {
                    symbols.add(new LeftBracket(row));
                }
            }
            String filter = (String)map.get("df");
            Object measureId = map.get("m");
            if (StringUtils.isNotEmpty((CharSequence)filter) || PAUtil.idNotNull((Object)measureId)) {
                if (measureId instanceof Long) {
                    FindFactor findFactor = new FindFactor(row, model, filter, (Long)measureId);
                    symbols.add(findFactor);
                    isfindfactor = true;
                } else {
                    isfindfactor = false;
                }
            } else {
                isfindfactor = false;
            }
            BigDecimal figure = (BigDecimal)map.get("v");
            if (figure != null) {
                if (isfindfactor) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5ea6\u91cf\u548c\u6570\u503c\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u3002", (String)"Formula_5", (String)"fi-pa-business", (Object[])new Object[0]), i + 1));
                }
                FigureFactor figureFactor = new FigureFactor(row, figure);
                symbols.add(figureFactor);
            } else if (!isfindfactor) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u8bf7\u5f55\u5165\u5ea6\u91cf\u6216\u6570\u503c\u3002", (String)"Formula_6", (String)"fi-pa-business", (Object[])new Object[0]), i + 1));
            }
            String rightbracket = (String)map.get("rb");
            if (rightbracket != null) {
                for (int j = 0; j < rightbracket.length(); ++j) {
                    symbols.add(new RightBracket(row));
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)(operator = (String)map.get("op")))) continue;
            symbols.add(Operation.of(operator));
        }
        return Formula.newFactor(symbols);
    }

    private static Factor newFactor(List<Symbol> symbols) {
        if ((symbols = Formula.clear(symbols)).size() == 1) {
            Symbol symbol = symbols.get(0);
            if (symbol instanceof Factor) {
                return (Factor)symbol;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u65e0\u8ba1\u7b97\u56e0\u5b50\u3002", (String)"Formula_7", (String)"fi-pa-business", (Object[])new Object[0]), symbol));
        }
        return new Formula(symbols);
    }

    private static List<Symbol> clear(List<Symbol> symbols) {
        if (symbols.size() < 3) {
            return symbols;
        }
        int leftCount = 0;
        int rightCount = 0;
        if (symbols.get(0) instanceof LeftBracket) {
            ++leftCount;
        }
        Integer rightPos = null;
        for (int i = 1; i < symbols.size(); ++i) {
            Symbol symbol = symbols.get(i);
            if (symbol instanceof RightBracket) {
                ++rightCount;
            } else if (symbol instanceof LeftBracket) {
                ++leftCount;
            }
            if (rightPos != null || leftCount != rightCount) continue;
            rightPos = i;
        }
        if (leftCount != rightCount) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"Formula_8", (String)"fi-pa-business", (Object[])new Object[0]));
        }
        if (rightPos == symbols.size() - 1) {
            return Formula.clear(symbols.subList(1, symbols.size() - 1));
        }
        return symbols;
    }

    private Factor createSub(int fromIndex, int toIndex) {
        List<Symbol> subList = this.symbols.subList(fromIndex, toIndex);
        return Formula.newFactor(subList);
    }

    @Override
    public BigDecimal calc(CvprofitQueryParam param) {
        if (this.operation == null) {
            return this.rightFactor.calc(param);
        }
        return this.operation.operate(this.leftFactor.calc(param), this.rightFactor.calc(param));
    }

    public String toString() {
        return this.symbols.stream().map(Object::toString).collect(Collectors.joining());
    }
}

