/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.cost.formula;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.pa.cost.formula.Symbol;

public enum Operation implements Symbol
{
    ADD("+", 0),
    SUBTRACT("-", 0),
    MULTIPLY("*", 1),
    DIVIDE("/", 1);

    private final int priority;
    private final String symbol;

    private Operation(String symbol, int priority) {
        this.symbol = symbol;
        this.priority = priority;
    }

    public static Operation of(String symbol) {
        for (Operation value : Operation.values()) {
            if (!value.getSymbol().equals(symbol)) continue;
            return value;
        }
        throw new KDBizException("Operation not exsit this symbol");
    }

    public boolean eq(Object symbol) {
        if (symbol instanceof String) {
            return Objects.equals(this.symbol, symbol);
        }
        return Objects.equals(this, symbol);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getPriority() {
        return this.priority;
    }

    public BigDecimal operate(BigDecimal leftV, BigDecimal rightV) {
        if (leftV == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b26\u53f7\u201c%s\u201d\u5de6\u8fb9\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"Operation_2", (String)"fi-pa-business", (Object[])new Object[0]), this.getSymbol()));
        }
        if (rightV == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b26\u53f7\u201c%s\u201d\u53f3\u8fb9\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"Operation_3", (String)"fi-pa-business", (Object[])new Object[0]), this.getSymbol()));
        }
        if (ADD == this) {
            return leftV.add(rightV);
        }
        if (SUBTRACT == this) {
            return leftV.subtract(rightV);
        }
        if (MULTIPLY == this) {
            return leftV.multiply(rightV);
        }
        if (DIVIDE == this) {
            if (rightV.compareTo(BigDecimal.ZERO) == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9664\u6570\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u5206\u6790\u65b9\u6848\u53d6\u503c\u516c\u5f0f\u4e2d\u7684\u5206\u6bcd\u53d6\u503c\u662f\u5426\u6b63\u786e\u3002", (String)"Operation_1", (String)"fi-pa-business", (Object[])new Object[0]));
            }
            return leftV.divide(rightV, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public String toString() {
        return this.symbol;
    }
}

