/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.dataAdjust;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.enums.MeasureTypeEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;

public class DataAdjustUtils {
    public static List<Integer> getSourceDataRow(Map<String, String> dataStyle) {
        return dataStyle.entrySet().stream().filter(entry -> "gray".equals(entry.getValue())).map(entry -> Integer.parseInt(((String)entry.getKey()).split(",")[1])).collect(Collectors.toList());
    }

    public static int getValidFieldIndex(Object[][] columns) {
        return DataAdjustUtils.getFieldIndexByName(columns, "valid", false);
    }

    public static int getIdFieldIndex(Object[][] columns) {
        return DataAdjustUtils.getFieldIndexByName(columns, "id", true);
    }

    public static int getFieldIndexByName(Object[][] columns, String name, boolean fullMatch) {
        if (fullMatch) {
            return IntStream.range(0, columns.length).filter(index -> columns[index][1] != null && columns[index][1].toString().equals(name)).findFirst().orElse(-1);
        }
        return IntStream.range(0, columns.length).filter(index -> columns[index][1] != null && (columns[index][1].toString().equals(name) || columns[index][1].toString().split("\\?")[0].equals(name))).findFirst().orElse(-1);
    }

    public static List<String> getUnValidRowBillNo(Object[] pks) {
        String selectFields = String.join((CharSequence)",", "billno", "adjustjson_tag", "analysismodel");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pa_dataadjust", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("billstatus", "=", (Object)"A")});
        return DataAdjustUtils.getUnValidRowBillNo(load);
    }

    public static List<String> getUnValidRowBillNo(DynamicObject[] bills) {
        return Arrays.stream(bills).filter(bill -> !((Set)DataAdjustUtils.getValidAndUnvalidRowIndexs((DynamicObject)bill).item1).isEmpty()).map(bill -> bill.getString("billno")).collect(Collectors.toList());
    }

    public static Tuple<Set<Integer>, Map<Integer, Long>> getValidAndUnvalidRowIndexs(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        List<String> skipFields = Arrays.asList("id", "adjustseq", "adjustdatastate", "remark", "valid");
        QFilter commonQfilter = new QFilter("collectstatus", "=", (Object)1).and("situationtype", "=", (Object)0).and("del", "!=", (Object)1);
        String adjustJson = bill.getString("adjustjson_tag");
        DynamicObject anaModel = bill.getDynamicObject("analysismodel");
        String entityNumber = PACommonConstans.buildEntityName((String)anaModel.getString("tablenumber"));
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO paDynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        String[][] columns = paDynamicEntryDTO.getColumns();
        Object[][] data = paDynamicEntryDTO.getData();
        List<Integer> sourceDataRow = DataAdjustUtils.getSourceDataRow(paDynamicEntryDTO.getDataStyle());
        HashSet<Integer> unvalidIndexs = new HashSet<Integer>(columns.length);
        HashMap<Integer, Long> validIndexs = new HashMap<Integer, Long>(columns.length);
        for (int i = 0; i < data.length; ++i) {
            Object[] rowData = data[i];
            if (!sourceDataRow.contains(i)) continue;
            QFilter rowColumnFilter = commonQfilter.copy();
            for (int j = 0; j < columns.length; ++j) {
                String fieldName = columns[j][1];
                if (skipFields.contains(fieldName)) continue;
                rowColumnFilter.and(new QFilter(fieldName, "=", rowData[j]));
            }
            DynamicObject validData = DataAdjustUtils.isValidRowData(entityNumber, new QFilter[]{rowColumnFilter});
            if (validData != null) {
                validIndexs.put(i, validData.getLong("id"));
                continue;
            }
            unvalidIndexs.add(i);
        }
        return Tuple.create(unvalidIndexs, validIndexs);
    }

    public static DynamicObject isValidRowData(String entityNumber, QFilter[] qFilters) {
        return QueryServiceHelper.queryOne((String)entityNumber, (String)"id", (QFilter[])qFilters);
    }

    public static List<String> getWrongAdjustJsonDataBillno(Object[] pks) {
        String selectFields = String.join((CharSequence)",", "billno", "adjustjson_tag", "billstatus", "analysismodel");
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pa_dataadjust", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("billstatus", "=", (Object)"A")});
        return Arrays.stream(bills).filter(bill -> !DataAdjustUtils.checkAdjustJsonDataRight(bill)).map(bill -> bill.getString("billno")).collect(Collectors.toList());
    }

    public static String existDBTable(Object pk) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"pa_dataadjust", (String)"analysismodel", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (bill == null) {
            return ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"DataAdjustUtils_2", (String)"fi-pa-business", (Object[])new Object[0]);
        }
        DynamicObject analysisModel = bill.getDynamicObject("analysismodel");
        String errMsg = null;
        if (analysisModel != null && StringUtils.isBlank((String)analysisModel.getString("tablenumber"))) {
            errMsg = ResManager.loadKDString((String)"\u672c\u5355\u6240\u9009\u6a21\u578b\u672a\u5efa\u7acb\u6570\u636e\u8868\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u3002", (String)"DataAdjustUtils_1", (String)"fi-pa-business", (Object[])new Object[0]);
        }
        return errMsg;
    }

    public static boolean checkAdjustJsonDataRight(DynamicObject bill) {
        String adjustJson = bill.getString("adjustjson_tag");
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)((List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0])).get(0);
        String[][] columns = dynamicEntryDTO.getColumns();
        List<String> skipFields = Arrays.asList("id", "adjustseq", "adjustdatastate", "valid", "remark");
        List checkColumns = Arrays.stream(columns).filter(column -> !skipFields.contains(column[1])).map(column -> column[1]).sorted(Comparator.comparing(String::hashCode)).collect(Collectors.toList());
        DynamicObject analysisModel = bill.getDynamicObject("analysismodel");
        Map columnMap = PAAnalysisModelHelper.queryDimensionAndMeasureById((Object)analysisModel.get("id"));
        List dimFields = Arrays.stream((Object[])columnMap.get("dimensionmapentry")).map(dim -> dim.getString("number").toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        List meaFields = Arrays.stream((Object[])columnMap.get("measuremapentry")).filter(mea -> MeasureTypeEnum.ORDINARY == MeasureTypeEnum.getEnum((String)mea.getString("measuretype"))).map(mea -> mea.getString("number")).collect(Collectors.toList());
        dimFields.addAll(meaFields);
        dimFields.sort(Comparator.comparing(String::hashCode));
        return checkColumns.toString().equals(dimFields.toString());
    }
}

