/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.pa.common.cache.DistributeCache;
import kd.fi.pa.common.cache.IDataCacheModule;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.engine.action.IPaAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.model.AdjustRule;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.ExecuteEngineService;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.enums.WriteOffTypeEnum;
import kd.fi.pa.handle.IDataSummaryHandler;
import kd.fi.pa.utils.AnalysisModelHashUtil;
import kd.fi.pa.utils.ExecutionLogUtil;

public class AdjustAction
implements IPaAction {
    private static final DistributeCache DISTRIBUTE_CACHE = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.PA);
    private static final String cacheKeyPrefix = "adjustConfirm_";
    private static final Log logger = LogFactory.getLog(AdjustAction.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(IRule rule, ExecutorLog log) {
        AdjustRule adjustRule = (AdjustRule)rule;
        Long adjustId = adjustRule.getId();
        DynamicObject adjustDyo = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pa_dataadjust");
        logger.info(String.format("[FI-PA] Start the adjust task: adjustId:{%1$s}, adjustBillNo:{%2$s}", adjustId, adjustDyo.getString("billno")));
        String adjustJson = adjustDyo.getString("adjustjson_tag");
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        String[][] columns = dynamicEntryDTO.getColumns();
        Object[][] data = dynamicEntryDTO.getData();
        Map supSonMap = dynamicEntryDTO.getSupSonMap() == null ? new HashMap(4) : dynamicEntryDTO.getSupSonMap();
        Map dataStyleMap = dynamicEntryDTO.getDataStyle();
        DynamicObject anaModel = adjustDyo.getDynamicObject("analysismodel");
        List modelHashDimensionNumberList = AnalysisModelHashUtil.queryModelHashDimension((DynamicObject)anaModel);
        String detailModelEntityNumber = PACommonConstans.buildDetailEntityName((String)anaModel.getString("tablenumber"));
        BigDecimal zero = new BigDecimal("0");
        HashSet<Long> sourceDataIdSet = new HashSet<Long>(data.length - supSonMap.size());
        long[] ids = DB.genGlobalLongIds((int)(supSonMap.isEmpty() ? 0 : new HashSet(supSonMap.values()).size()));
        int idx = 0;
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>(data.length);
        Date now = new Date();
        boolean detailContainsDimHash = AnalysisModelHashUtil.isModelContainsDimHash((String)detailModelEntityNumber);
        for (int i = 0; i < data.length; ++i) {
            DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)detailModelEntityNumber);
            String typeColor = (String)dataStyleMap.get("adjustdatastate," + i);
            int loopSize = columns.length;
            long dataId = Long.parseLong(String.valueOf(data[i][loopSize - 1]));
            if ("gray".equals(typeColor)) {
                newDyo.set("datastatus", (Object)-3);
                newDyo.set("id", (Object)ids[idx++]);
                newDyo.set("execparentbillid", (Object)dataId);
                --loopSize;
                sourceDataIdSet.add(dataId);
            } else if ("red".equals(typeColor)) {
                newDyo.set("datastatus", (Object)3);
            } else {
                newDyo.set("datastatus", (Object)3);
                newDyo.set("execparentbillid", (Object)Long.parseLong(String.valueOf(data[(Integer)supSonMap.get(i)][loopSize - 1])));
            }
            for (int j = 2; j < loopSize; ++j) {
                if ("remark".equals(columns[j][1]) || "valid".equals(columns[j][1])) continue;
                if ("gray".equals(typeColor) && "99".equals(columns[j][0]) && !"2".equals(columns[j][3])) {
                    if (data[i][j] == null) continue;
                    newDyo.set(columns[j][1], (Object)zero.subtract((BigDecimal)data[i][j]));
                    continue;
                }
                newDyo.set(columns[j][1], data[i][j]);
            }
            newDyo.set("execlogid", (Object)log.getLogId());
            newDyo.set("subexeclogid", (Object)log.getRuleExecutionLogId());
            newDyo.set("offstatus", (Object)0);
            newDyo.set("collectstatus", (Object)0);
            newDyo.set("operationstatus", (Object)0);
            newDyo.set("situationtype", (Object)0);
            newDyo.set("del", (Object)0);
            newDyo.set("createtime", (Object)now);
            newDyo.set("createstamp", (Object)now.getTime());
            if (detailContainsDimHash) {
                newDyo.set("dimhash", (Object)AnalysisModelHashUtil.calculateDimHash((DynamicObject)newDyo, (List)modelHashDimensionNumberList));
            }
            saveDataList.add(newDyo);
        }
        QFilter sourceIdFilter = new QFilter("execparentbillid", "in", sourceDataIdSet);
        DynamicObjectCollection execCol = QueryServiceHelper.query((String)detailModelEntityNumber, (String)"subexeclogid", (QFilter[])sourceIdFilter.toArray());
        HashSet<Long> subExecLogIdSet = new HashSet<Long>(execCol.size());
        for (DynamicObject dyo : execCol) {
            subExecLogIdSet.add(dyo.getLong("subexeclogid"));
        }
        Date curTime = new Date();
        Date createTime = adjustDyo.getDate("createtime");
        Date auditTime = adjustDyo.getDate("auditdate");
        QFilter timeFilterAd = new QFilter("execution_time", ">=", (Object)createTime).and("execution_time", "<=", (Object)curTime).and("execution_status", "=", (Object)"2");
        QFilter timeFilterRule = new QFilter("execution_time", ">=", (Object)createTime).and("execution_time", "<=", (Object)auditTime).and("execution_status", "=", (Object)"2");
        DynamicObjectCollection adExecLogCol = QueryServiceHelper.query((String)"pa_adexeclog", (String)"execution_logpk,ad_pk", (QFilter[])new QFilter("id", "in", subExecLogIdSet).and(timeFilterAd).toArray(), (String)"execution_time desc");
        DynamicObjectCollection ruleExecLogCol = QueryServiceHelper.query((String)"pa_ruleexeclog", (String)"execution_logpk,rule_pk", (QFilter[])new QFilter("id", "in", subExecLogIdSet).and(timeFilterRule).toArray(), (String)"execution_time desc");
        String validateMark = DISTRIBUTE_CACHE.get(cacheKeyPrefix + adjustId);
        if ("yesMark".equals(validateMark)) {
            DISTRIBUTE_CACHE.remove(cacheKeyPrefix + adjustId);
            for (DynamicObject dyo : adExecLogCol) {
                ExecutionLogDTO executionLog = ExecutionLogUtil.buildLogDTO((DynamicObject)adjustDyo, (String)ExecutionTypeEnum.MANUAL.getCode(), null, (ExecutionModeEnum)ExecutionModeEnum.writeOff);
                executionLog.setCurrentRowBusinessRuleId(Long.valueOf(dyo.getLong("ad_pk")));
                executionLog.setEditLogId(Long.valueOf(dyo.getLong("execution_logpk")));
                executionLog.setWriteOffType(WriteOffTypeEnum.SINGLE_ADJUST.getCode());
                executionLog.setNeedLock(Boolean.FALSE);
                ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                executeEngineService.work(executionLog);
            }
            if (!ruleExecLogCol.isEmpty()) {
                int ruleExecCnt = ruleExecLogCol.size();
                HashSet<Object> idSet = new HashSet<Object>(ruleExecCnt);
                HashMap<Object, Set> logStepMap = new HashMap<Object, Set>(ruleExecCnt);
                for (DynamicObject dyo : ruleExecLogCol) {
                    Object logId = dyo.get("execution_logpk");
                    Set stepSet = logStepMap.computeIfAbsent(logId, k -> new HashSet(ruleExecCnt));
                    stepSet.add(dyo.get("rule_pk"));
                    idSet.add(logId);
                }
                Map executionLogMap = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)"pa_executionlog");
                int logCnt = executionLogMap.size();
                HashMap<Object, Set> ruleLogMap = new HashMap<Object, Set>(logCnt);
                idSet.clear();
                for (DynamicObject dyo : executionLogMap.values()) {
                    for (DynamicObject ent : dyo.getDynamicObjectCollection("entryentity")) {
                        Object ruleId = ent.get("entry_businessrule_id");
                        Set logSet = ruleLogMap.computeIfAbsent(ruleId, k -> new HashSet(logCnt));
                        logSet.add(dyo.get("id"));
                        idSet.add(ruleId);
                    }
                }
                Map businessRuleMap = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)"pa_businessrule");
                for (DynamicObject dyo : businessRuleMap.values()) {
                    Object ruleId = dyo.get("id");
                    Set logSet = (Set)ruleLogMap.get(ruleId);
                    block23: for (Object logId : logSet) {
                        Set stepSet = (Set)logStepMap.get(logId);
                        for (DynamicObject ent : dyo.getDynamicObjectCollection("stepentry")) {
                            if (!stepSet.contains(ent.get("cardderivationmodel_id")) && !stepSet.contains(ent.get("cardsharemodel_id"))) continue;
                            ExecutionLogDTO executionLog = ExecutionLogUtil.buildLogDTO((DynamicObject)adjustDyo, (String)ExecutionTypeEnum.MANUAL.getCode(), null, (ExecutionModeEnum)ExecutionModeEnum.writeOff);
                            executionLog.setCurrentRowBusinessRuleId(Long.valueOf(Long.parseLong(ruleId.toString())));
                            executionLog.setEditLogId(Long.valueOf(Long.parseLong(logId.toString())));
                            executionLog.setWriteOffType(WriteOffTypeEnum.SINGLE_RULE.getCode());
                            executionLog.setNeedLock(Boolean.FALSE);
                            ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                            executeEngineService.work(executionLog);
                            continue block23;
                        }
                    }
                }
            }
        } else if (!adExecLogCol.isEmpty() || !ruleExecLogCol.isEmpty()) {
            DISTRIBUTE_CACHE.put(cacheKeyPrefix + adjustId, (Object)"confirmMark");
            return;
        }
        logger.info(String.format("[FI-PA] AdjustDyo billno:{%s}", adjustDyo.getString("billno")));
        boolean executeFail = false;
        try {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveDataList.toArray(new DynamicObject[0]));
                    adjustDyo.set("adjuststatus", (Object)"2");
                    adjustDyo.set("faildesc", null);
                    SaveServiceHelper.update((DynamicObject)adjustDyo);
                    IDataSummaryHandler.getInstance().summary(saveDataList, Long.valueOf(anaModel.getLong("id")));
                }
                catch (Exception e) {
                    executeFail = true;
                    txHandle.markRollback();
                    throw e;
                }
            }
            if (!executeFail) return;
        }
        catch (Exception e) {
            try {
                executeFail = true;
                logger.error(String.format("[FI-PA] AdjustAction occur an error: adjustDyo:{%s},  msg:{%s}", adjustDyo.getString("billno"), e));
                throw e;
            }
            catch (Throwable throwable) {
                if (!executeFail) throw throwable;
                adjustDyo.set("adjuststatus", (Object)"0");
                String errMsg = ResManager.loadKDString((String)"\u6267\u884c\u51fa\u9519\uff0c\u5177\u4f53\u539f\u56e0\u8bf7\u5728monitor\u5e73\u53f0\u4e2d\u641c\u7d22\u201c[FI-PA]AdjustAction occur an error\u201d\u67e5\u770b\u3002", (String)"AdjustAction_0", (String)"fi-pa-business", (Object[])new Object[0]);
                adjustDyo.set("faildesc", (Object)(errMsg.length() > 255 ? errMsg.substring(0, 255) : errMsg));
                SaveServiceHelper.update((DynamicObject)adjustDyo);
                throw throwable;
            }
        }
        adjustDyo.set("adjuststatus", (Object)"0");
        String errMsg = ResManager.loadKDString((String)"\u6267\u884c\u51fa\u9519\uff0c\u5177\u4f53\u539f\u56e0\u8bf7\u5728monitor\u5e73\u53f0\u4e2d\u641c\u7d22\u201c[FI-PA]AdjustAction occur an error\u201d\u67e5\u770b\u3002", (String)"AdjustAction_0", (String)"fi-pa-business", (Object[])new Object[0]);
        adjustDyo.set("faildesc", (Object)(errMsg.length() > 255 ? errMsg.substring(0, 255) : errMsg));
        SaveServiceHelper.update((DynamicObject)adjustDyo);
        return;
    }
}

