/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.action;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.dto.BusinessExecutionParamDTO;
import kd.fi.pa.engine.action.IPaAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.model.BatchWriteOffRule;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PALogHelper;

public class BatchWriteOffAction
implements IPaAction {
    private static final Log logger = LogFactory.getLog(BatchWriteOffAction.class);

    @Override
    public void execute(IRule rule, ExecutorLog executorLog) {
        BatchWriteOffRule currentRule = (BatchWriteOffRule)rule;
        logger.info("[FI-PA] Start the writeOff task");
        long logId = executorLog.getLogId();
        Long currentPeriodId = currentRule.getCurrentPeriodId();
        BusinessExecutionParamDTO paramDTO = PALogHelper.getExecutionLogCondition((Long)logId);
        Date startDate = paramDTO.getStartDate();
        Date endDate = paramDTO.getEndDate();
        Long orgId = currentRule.getOrgId();
        DynamicObject analysisModel = currentRule.getAnalysisModel();
        String detailEntityNumber = PACommonConstans.buildDetailEntityName((String)analysisModel.getString("tablenumber"));
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("periodId", currentPeriodId);
        param.put("orgId", orgId);
        param.put("accounts", null);
        param.put("isAccount", false);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        QFilter commonFilter = PAExecutorHelper.processCommonFilters(param, (DynamicObjectCollection)dimensionEntry).and(PAExecutorHelper.getCommonOffFilter());
        DynamicObject[] dys = PAExecutorHelper.processModelDataSet((String)detailEntityNumber, (QFilter)commonFilter);
        if (dys.length == 0) {
            String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u51b2\u9500\u6570\u636e\u5f02\u5e38\uff1a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4e0d\u5230\u6a21\u578b\u8868\u6570\u636e\u6216\u6a21\u578b\u8868\u6570\u636e\u672a\u7ecf\u4e1a\u52a1\u5904\u7406", (String)"BatchWriteOffAction_0", (String)"fi-pa-business", (Object[])new Object[0]);
            executorLog.setRemarkInfo(msg);
            executorLog.setLevitationMessage(msg);
            logger.error("[FI-PA] BatchWriteOff error! msg=%s", (Object)msg);
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
        }
        PAExecutorHelper.processResultData((long)logId, (DynamicObject)analysisModel, (String)detailEntityNumber, (DynamicObject[])dys, null);
    }
}

