/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.dto.ModelTableSummaryDetailMappingDTO;
import kd.fi.pa.engine.action.IPaAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.engine.model.OnceWriteOffRule;
import kd.fi.pa.enums.WriteOffTypeEnum;
import kd.fi.pa.handle.IDataSummaryHandler;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PATableDataHelper;

public class OnceWriteOffAction
implements IPaAction {
    private static final Log logger = LogFactory.getLog(OnceWriteOffAction.class);

    @Override
    public void execute(IRule rule, ExecutorLog executorLog) {
        long analysisModelId;
        logger.info("[FI-PA] OnceWriteOffAction begin");
        OnceWriteOffRule onceWriteOffRule = (OnceWriteOffRule)rule;
        Long id = onceWriteOffRule.getId();
        char writeOffType = onceWriteOffRule.getWriteOffType();
        logger.info(String.format("FI-PA] WriteOffType : %c, id : %d", Character.valueOf(writeOffType), id));
        if (WriteOffTypeEnum.SINGLE_ADJUST.getCode() == writeOffType) {
            DynamicObject adjustDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_dataadjust");
            if (Objects.isNull(adjustDyo)) {
                String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8c03\u6574\u5355", (String)"OnceWriteOffAction_0", (String)"fi-pa-business", (Object[])new Object[0]);
                executorLog.setRemarkInfo(msg);
                executorLog.setLevitationMessage(msg);
                logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
                throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
            }
            analysisModelId = adjustDyo.getLong("analysismodel_id");
        } else {
            DynamicObject businessRule = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_businessrule");
            if (Objects.isNull(businessRule)) {
                String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u89c4\u5219", (String)"OnceWriteOffAction_1", (String)"fi-pa-business", (Object[])new Object[0]);
                executorLog.setRemarkInfo(msg);
                executorLog.setLevitationMessage(msg);
                logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
                throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
            }
            analysisModelId = businessRule.getLong("analysismodel_id");
        }
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        String detailModelEntityNumber = PACommonConstans.buildDetailEntityName((String)analysisModel.getString("tablenumber"));
        Long executionLogId = onceWriteOffRule.getExecutorLogId();
        logger.info("[FI-PA] ExecutionLogId=%s", (Object)executionLogId);
        Set<Long> longs = this.whetherBusinessPlan(writeOffType, id, executionLogId);
        logger.info("[FI-PA] Longs=%s", (Object)longs.toString());
        QFilter filter = new QFilter("execlogid", "=", (Object)executionLogId);
        if (!CollectionUtils.isEmpty(longs)) {
            filter.and("subexeclogid", "in", longs);
        }
        String queryField = "id,execparentbillid";
        logger.info("[FI-PA] QueryField=%s, filter=%s", (Object)queryField, (Object)filter.toString());
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)detailModelEntityNumber, (String)queryField, (QFilter[])filter.toArray());
        if (objectCollection.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u4e2d\u672a\u8bb0\u5f55\u660e\u7ec6\u6570\u636e", (String)"OnceWriteOffAction_2", (String)"fi-pa-business", (Object[])new Object[0]);
            executorLog.setRemarkInfo(msg);
            executorLog.setLevitationMessage(msg);
            logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
        }
        long analysisModelLong = analysisModel.getLong("id");
        HashSet<Long> targetIds = new HashSet<Long>(10);
        HashSet<Long> sourceIds = new HashSet<Long>(10);
        for (DynamicObject dy : objectCollection) {
            targetIds.add(dy.getLong("id"));
            sourceIds.add(dy.getLong("execparentbillid"));
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.addAll(targetIds);
        ids.addAll(sourceIds);
        ArrayList<Long> allWriteOffIds = new ArrayList<Long>(targetIds);
        String fields = PAExecutorHelper.getPropByEntity((String)detailModelEntityNumber);
        QFilter filterId = new QFilter("id", "in", allWriteOffIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)detailModelEntityNumber, (String)fields, (QFilter[])new QFilter[]{filterId});
        if (query.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u89c4\u5219\u6240\u4ea7\u751f\u7684\u7ed3\u679c\u6570\u636e", (String)"OnceWriteOffAction_3", (String)"fi-pa-business", (Object[])new Object[0]);
            executorLog.setRemarkInfo(msg);
            executorLog.setLevitationMessage(msg);
            logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
        }
        for (DynamicObject dy : query) {
            long offStatus = dy.getLong("offstatus");
            if (1L != offStatus) continue;
            String msg = ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e\u5df2\u7ecf\u51b2\u9500", (String)"OnceWriteOffAction_4", (String)"fi-pa-business", (Object[])new Object[0]);
            executorLog.setRemarkInfo(msg);
            executorLog.setLevitationMessage(msg);
            logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
        }
        if ('2' != writeOffType) {
            Long[] detailIds = new Long[ids.size()];
            List summaryIdList = PATableDataHelper.querySummaryIdByDetails((String)detailModelEntityNumber, (Long[])ids.toArray(detailIds));
            Long[] summaryIds = new Long[summaryIdList.size()];
            List summaryDetails = PATableDataHelper.queryModelTableSummaryDetailMappings((String)detailModelEntityNumber, (boolean)false, (Long[])summaryIdList.toArray(summaryIds));
            this.checkAndFindAdjustIds(summaryDetails, ids, allWriteOffIds);
        }
        logger.info("[FI-PA] AllWriteOffIds=%s", (Object)((Object)allWriteOffIds).toString());
        this.updateAndSaveDate(fields, detailModelEntityNumber, allWriteOffIds, analysisModel, executorLog);
        logger.info("[FI-PA] OnceWriteOffAction end");
    }

    private Set<Long> whetherBusinessPlan(char writeOffType, Long businessId, Long executionLogId) {
        HashSet<Long> rule_execution_logIds = new HashSet<Long>(10);
        if (WriteOffTypeEnum.SINGLE_ADJUST.getCode() == writeOffType) {
            return rule_execution_logIds;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)executionLogId, (String)"pa_executionlog");
        DynamicObject businessPlanObj = dynamicObject.getDynamicObject("business_plan");
        if (Objects.isNull(businessPlanObj)) {
            return rule_execution_logIds;
        }
        HashSet<Long> ruleIds = new HashSet<Long>(10);
        DynamicObject business = BusinessDataServiceHelper.loadSingleFromCache((Object)businessId, (String)"pa_businessrule");
        DynamicObjectCollection dyCol = business.getDynamicObjectCollection("stepentry");
        for (DynamicObject entryObj : dyCol) {
            String handleType = (String)entryObj.get("cardhandletype");
            Long ruleId = "A".equals(handleType) ? (Long)entryObj.get("cardderivationmodel_id") : (Long)entryObj.get("cardsharemodel_id");
            ruleIds.add(ruleId);
        }
        QFilter filter = new QFilter("execution_logpk", "=", (Object)executionLogId);
        filter.and("rule_pk", "in", ruleIds);
        DynamicObjectCollection ruleExecLogCol = QueryServiceHelper.query((String)"pa_ruleexeclog", (String)"id", (QFilter[])filter.toArray());
        for (DynamicObject dyo : ruleExecLogCol) {
            rule_execution_logIds.add(dyo.getLong("id"));
        }
        return rule_execution_logIds;
    }

    private void checkAndFindAdjustIds(List<ModelTableSummaryDetailMappingDTO> summaryDetails, List<Long> ids, List<Long> allWriteOffIds) {
        HashSet<Long> adjustId = new HashSet<Long>(10);
        for (ModelTableSummaryDetailMappingDTO dto : summaryDetails) {
            Long aLong;
            List detailIds1 = dto.getDetailIds();
            if (ids.containsAll(detailIds1) || ids.contains(detailIds1.get(0))) continue;
            Iterator iterator = detailIds1.iterator();
            while (iterator.hasNext() && !ids.contains(aLong = (Long)iterator.next())) {
                adjustId.add(aLong);
            }
        }
        allWriteOffIds.addAll(this.selectAdjustDataId(adjustId));
    }

    private Set<Long> selectAdjustDataId(Set<Long> adjustId) {
        HashSet<Long> allAdjustDataId = new HashSet<Long>(10);
        if (adjustId.isEmpty()) {
            return allAdjustDataId;
        }
        HashSet<Long> sourceIds = new HashSet<Long>(10);
        QFilter detailFilter = new QFilter("target_pk", "in", adjustId);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_adexecdetail", (String)"source_pk", (QFilter[])new QFilter[]{detailFilter});
        for (DynamicObject dynamicObject : dynamicObjectMap.values()) {
            sourceIds.add(dynamicObject.getLong("source_pk"));
        }
        if (sourceIds.isEmpty()) {
            return allAdjustDataId;
        }
        QFilter sourceFilter = new QFilter("source_pk", "in", sourceIds);
        Map dynamicObjectMapDetail = BusinessDataServiceHelper.loadFromCache((String)"pa_adexecdetail", (String)"target_pk", (QFilter[])new QFilter[]{sourceFilter});
        for (DynamicObject dynamicObject : dynamicObjectMapDetail.values()) {
            allAdjustDataId.add(dynamicObject.getLong("target_pk"));
        }
        return allAdjustDataId;
    }

    private void updateAndSaveDate(String fields, String entityNumber, List<Long> allWriteOffIds, DynamicObject analysisModel, ExecutorLog executorLog) {
        QFilter filterId = new QFilter("id", "in", allWriteOffIds);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)entityNumber, (String)fields, (QFilter[])new QFilter[]{filterId});
        if (dys.length == 0) {
            String msg = ResManager.loadKDString((String)"\u51b2\u9500\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u6267\u884c\u51b2\u9500\u64cd\u4f5c", (String)"OnceWriteOffAction_5", (String)"fi-pa-business", (Object[])new Object[0]);
            executorLog.setRemarkInfo(msg);
            executorLog.setLevitationMessage(msg);
            logger.error("FI-PA] OnceWriteOff error! msg=%s", (Object)msg);
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, msg);
        }
        List measureList = PAExecutorHelper.getMeasureListByModel((DynamicObject)analysisModel);
        ArrayList<DynamicObject> writeOffs = new ArrayList<DynamicObject>(dys.length);
        HashSet adjustIds = new HashSet();
        PAExecutorHelper.processCommonMeasures((String)entityNumber, (String)fields, (DynamicObject[])dys, (List)measureList, writeOffs, adjustIds, (Long)executorLog.getLogId());
        logger.info("[FI-PA] AdjustIds=%s", (Object)((Object)adjustIds).toString());
        DynamicObject[] adjustDys = PAExecutorHelper.processAdjustStatus((String)entityNumber, adjustIds);
        SaveServiceHelper.save((DynamicObject[])adjustDys);
        SaveServiceHelper.save((DynamicObject[])writeOffs.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dys);
        this.summaryData(writeOffs, analysisModel.getLong("id"));
    }

    private void summaryData(List<DynamicObject> writeOffsNewData, Long analysisModelId) {
        if (CollectionUtils.isEmpty(writeOffsNewData)) {
            return;
        }
        IDataSummaryHandler instance = IDataSummaryHandler.getInstance();
        instance.summary(writeOffsNewData, analysisModelId);
    }
}

