/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.exception;

import kd.bos.exception.ErrorCode;
import kd.fi.pa.engine.exception.PABusinessException;

public class PABusinessErrorCodeBox {
    public static final PABusinessErrorCodeBox BUSINESS = PABusinessErrorCodeBox.create("BUSINESS");
    public static final PABusinessErrorCodeBox SYSTEM = PABusinessErrorCodeBox.create("SYSTEM");
    public static final PABusinessErrorCodeBox OTHER = PABusinessErrorCodeBox.create("OTHER");
    private final String code;

    private PABusinessErrorCodeBox(String code) {
        this.code = code;
    }

    private static PABusinessErrorCodeBox create(String code) {
        return new PABusinessErrorCodeBox(code);
    }

    private String getMessage() {
        switch (this.code) {
            case "BUSINESS": {
                return "%s";
            }
            case "SYSTEM": {
                return "[FI-PA]System error:%s";
            }
            case "OTHER": {
                return "[FI-PA]Other error:%s";
            }
        }
        return "undefined code: " + this.code;
    }

    ErrorCode getErrorCode() {
        return new ErrorCode("fi.pa." + this.code, this.getMessage());
    }

    public boolean match(PABusinessException e) {
        return this.getErrorCode().equals((Object)e.getErrorCode());
    }
}

