/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.engine.executor.allocation.receiver.ShareReceiverProcessor;
import kd.fi.pa.engine.executor.allocation.receiver.ShareReceiverProcessorFactory;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;

public class AllocationReceiverBuildExecutor {
    private static final Log logger = LogFactory.getLog(AllocationReceiverBuildExecutor.class);
    private final AllocationRule allocationRule;
    private final DynamicObject analysisModel;

    public AllocationReceiverBuildExecutor(AllocationRule allocationRule, DynamicObject analysisModel) {
        this.allocationRule = allocationRule;
        this.analysisModel = analysisModel;
    }

    public List<Map<String, String>> buildAlgoX(LogConfigDTO execConfig) {
        long startTime = System.currentTimeMillis();
        List<Map<String, String>> receiverList = null;
        ShareTypeEnum shareType = ShareTypeEnum.getShareTypeEnum((String)this.allocationRule.getShareType());
        ShareReceiverProcessor processor = ShareReceiverProcessorFactory.createProcessor(shareType);
        if (processor == null) {
            logger.warn("[FI-PA] ShareReceiverProcessor is null");
            receiverList = new ArrayList<Map<String, String>>(0);
        } else {
            receiverList = processor.buildReceivers(this.allocationRule, execConfig);
        }
        long costTime = System.currentTimeMillis() - startTime;
        if (costTime > 1000L) {
            logger.info("[FI-PA] build receiverList cost {}ms", (Object)costTime);
        }
        logger.info(String.format("[FI-PA] AllocationReceiverBuildExecutor BuildAlgoX success! receiverList:%s", receiverList));
        return receiverList;
    }
}

