/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.enginealgox.model.business.AllocationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PASituationTypeEnum;
import kd.fi.pa.helper.PACustomParamHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PAFilterHelper;
import kd.fi.pa.model.impl.PAAnalysisModelModel;
import kd.fi.pa.model.impl.PADimensionModel;

public class AllocationSenderBuildExecutor {
    private static final Log logger = LogFactory.getLog(AllocationSenderBuildExecutor.class);
    private static final String ALGO = AllocationSenderBuildExecutor.class.getName();
    private final AllocationRule allocationRule;
    private final DynamicObject analysisModel;

    public AllocationSenderBuildExecutor(AllocationRule allocationRule, DynamicObject analysisModel) {
        this.allocationRule = allocationRule;
        this.analysisModel = analysisModel;
    }

    public OrmInput[] buildAlgoX(AllocationBusinessDTO allocationBusinessDTO, LogConfigDTO execConfig) {
        String entityNumber = PACommonConstans.buildEntityName((String)this.analysisModel.getString("tablenumber"));
        String fields = this.getFields();
        QFilter excludeOrgQFilter = this.getQFilterExcludeOrg(execConfig);
        logger.info(String.format("[FI-PA] AllocationSenderBuildExecutor BuildAlgoX success! entityNumber:%s, fields:%s, qFilter:%s", entityNumber, fields, excludeOrgQFilter));
        int maxOrgInputCount = PACustomParamHelper.getMaxOrgInputCount();
        String orgDimNumber = allocationBusinessDTO.getModelConfigDTO().getOrgDimNumber();
        QFilter[] includeOrgQFilters = PAFilterHelper.splitQFilters((QFilter)excludeOrgQFilter, (String)orgDimNumber, (Object[])execConfig.getOrgIds().toArray(new Long[0]), (int)maxOrgInputCount);
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(includeOrgQFilters.length);
        for (QFilter qFilter : includeOrgQFilters) {
            ormInputList.add(new OrmInput(ALGO, entityNumber, fields, qFilter.toArray()));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private String getFields() {
        List<String> modelFieldList = ModelUtil.getModelFieldList(this.analysisModel);
        HashSet<String> fieldSet = new HashSet<String>(modelFieldList);
        return String.join((CharSequence)",", fieldSet);
    }

    private QFilter getQFilterExcludeOrg(LogConfigDTO execConfig) {
        QFilter qFilter = new QFilter("datastatus", "=", (Object)DataStatusEnum.SOURCE.getLongCode()).and(new QFilter("collectstatus", "=", (Object)OperationStatusEnum.USED.getLongCode())).and(new QFilter("situationtype", "=", (Object)PASituationTypeEnum.ACTUAL.getLongCode()));
        this.processQFilterByDimEntryExcludeOrg(qFilter, execConfig);
        this.processQFilterBySenderEntry(qFilter);
        return qFilter;
    }

    private void processQFilterByDimEntryExcludeOrg(QFilter qFilter, LogConfigDTO execConfig) {
        DynamicObjectCollection senderEntry = this.allocationRule.getSenderEntry();
        DynamicObjectCollection dimensionEntry = this.analysisModel.getDynamicObjectCollection("dimension_entry");
        boolean sendDimContainsAccount = false;
        DynamicObject accountDynamicObject = dimensionEntry.stream().filter(dy -> StringUtils.equals((CharSequence)DimensionNecessityEnum.ACCOUNT.getCode(), (CharSequence)dy.getString("necessity_dim"))).findFirst().orElse(null);
        if (accountDynamicObject != null) {
            String accountNumber = accountDynamicObject.getDynamicObject("dimension").getString("number");
            for (DynamicObject sendDynamicObject : senderEntry) {
                if (!StringUtils.equals((CharSequence)accountNumber, (CharSequence)sendDynamicObject.getDynamicObject("senddimension").getString("number"))) continue;
                sendDimContainsAccount = true;
            }
        }
        Long periodId = execConfig.getPeriod();
        Set<Long> accountIdSet = execConfig.getAccountIdSet();
        Date startDate = execConfig.getStartDate();
        Date endDate = execConfig.getEndDate();
        for (DynamicObject dim : dimensionEntry) {
            String number = dim.getDynamicObject("dimension").getString("number");
            DimensionNecessityEnum necessityEnum = DimensionNecessityEnum.getEnum((String)dim.getString("necessity_dim"));
            if (necessityEnum == null) continue;
            switch (necessityEnum) {
                case ORG: {
                    break;
                }
                case PERIOD: {
                    if (Objects.isNull(periodId)) {
                        PAExecutorHelper.processTimeDimFilter((QFilter)qFilter, (String)number, (Date)startDate, (Date)endDate);
                        break;
                    }
                    PAExecutorHelper.processCommonFilter((QFilter)qFilter, (String)number, (Object)periodId);
                    break;
                }
                case ACCOUNT: {
                    if (sendDimContainsAccount) break;
                    PAExecutorHelper.processCommonFilter((QFilter)qFilter, (String)number, accountIdSet);
                    break;
                }
            }
        }
    }

    private void processQFilterBySenderEntry(QFilter qFilter) {
        DynamicObjectCollection senderEntry = this.allocationRule.getSenderEntry();
        PAAnalysisModelModel paAnalysisModelModel = new PAAnalysisModelModel();
        paAnalysisModelModel.loadFromDynamicObject(this.analysisModel);
        for (DynamicObject sendDynamicObject : senderEntry) {
            String type = sendDynamicObject.getString("senddimtype");
            String number = sendDynamicObject.getDynamicObject("senddimension").getString("number");
            String sendCondition = sendDynamicObject.getString("combofield");
            String idStr = sendDynamicObject.getString("dimensionid");
            String valueStr = sendDynamicObject.getString("dimensionvalue");
            String text = sendDynamicObject.getString("dimensiontext_tag");
            String baseEntityId = sendDynamicObject.getString("sendmatename");
            PADimensionModel dimensionModel = paAnalysisModelModel.getDim(sendDynamicObject.getDynamicObject("senddimension").getPkValue());
            if (dimensionModel != null && dimensionModel.getDataType() == DimensionTypeEnum.DATABASE && dimensionModel.getSource() != null) {
                baseEntityId = dimensionModel.getSource().getNumber();
            }
            String value = "";
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)sendCondition);
            if (conditionEnum == FilterConditionEnum.IN || conditionEnum == FilterConditionEnum.NOT_IN) {
                value = ModelUtil.getDimValue(type, text, idStr, valueStr);
            }
            QFilter dimQFilter = ModelUtil.getDimQFilter(type, number, baseEntityId, sendCondition, value);
            qFilter.and(dimQFilter);
        }
    }
}

