/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enginealgox.utils.ModelUtil;

public class DerivationReceiverBuildExecutor {
    private static final Log logger = LogFactory.getLog(DerivationReceiverBuildExecutor.class);
    private static final String ALGO_KEY = DerivationReceiverBuildExecutor.class.getName();
    private final DerivationRule derivationRule;
    private final DynamicObject analysisModel;

    public DerivationReceiverBuildExecutor(DerivationRule derivationRule, DynamicObject analysisModel) {
        this.derivationRule = derivationRule;
        this.analysisModel = analysisModel;
    }

    public OrmInput buildAlgoX() {
        String derivationMode = this.derivationRule.getDerivationMode();
        OrmInput ormInput = null;
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_RELATIONSHIP: {
                ormInput = this.getReceiverDataByMappingRelationship();
                break;
            }
            case DERIVATION_MAPPING_TABLE: {
                ormInput = this.getReceiverDataByMappingTable();
                break;
            }
        }
        logger.info("[FI-PA] DerivationReceiverBuildExecutor BuildAlgoX success!");
        return ormInput;
    }

    private OrmInput getReceiverDataByMappingRelationship() {
        String selectFields = "entryentity.sourcedimtext source_dimtext,entryentity.targetdimtext target_dimtext";
        Long relationShipId = this.derivationRule.getMappingRelationShip().getLong("id");
        QFilter idFilter = new QFilter("id", "=", (Object)relationShipId);
        return new OrmInput(ALGO_KEY, "pa_mappingrelationship", selectFields, new QFilter[]{idFilter});
    }

    private OrmInput getReceiverDataByMappingTable() {
        String entityNumber = this.derivationRule.getMappingMapType();
        String selectFields = String.join((CharSequence)",", this.getBaseDataField());
        QFilter[] qFilter = this.getBaseDataQFilter();
        return new OrmInput(ALGO_KEY, entityNumber, selectFields, qFilter);
    }

    private Set<String> getBaseDataField() {
        HashSet<String> fieldSet = new HashSet<String>();
        DynamicObjectCollection mtSourceEntryEntity = this.derivationRule.getMtSourceEntryEntity();
        for (Object dy : mtSourceEntryEntity) {
            String mSourceField = dy.getString("mt_m_sourcefield_number");
            String mSourceFieldFormat = FieldUtil.otherFormatAlias(mSourceField);
            fieldSet.add(mSourceFieldFormat);
        }
        DynamicObjectCollection mtTargetEntryEntity = this.derivationRule.getMtTargetEntryEntity();
        for (DynamicObject dy : mtTargetEntryEntity) {
            String mTargetField = dy.getString("mt_m_targetfield_number");
            String mTargetFieldFormat = FieldUtil.otherFormatAlias(mTargetField);
            fieldSet.add(mTargetFieldFormat);
        }
        String entrySeqField = this.derivationRule.getEntrySeqField();
        if (StringUtils.isNotEmpty((String)entrySeqField)) {
            fieldSet.add(entrySeqField);
        }
        return fieldSet;
    }

    private QFilter[] getBaseDataQFilter() {
        if (ModelUtil.isExistField(this.derivationRule.getMappingMapType(), "enable")) {
            return new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        }
        return new QFilter[0];
    }
}

