/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.engine.model.DerivationRule;
import kd.fi.pa.enginealgox.model.business.DerivationBusinessDTO;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.FieldUtil;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PASituationTypeEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PACustomParamHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PAFilterHelper;

public class DerivationSenderBuildExecutor {
    private static final Log logger = LogFactory.getLog(DerivationSenderBuildExecutor.class);
    private static final String ALGO = DerivationSenderBuildExecutor.class.getName();
    private final DerivationRule derivationRule;
    private final DynamicObject analysisModel;

    public DerivationSenderBuildExecutor(DerivationRule derivationRule, DynamicObject analysisModel) {
        this.derivationRule = derivationRule;
        this.analysisModel = analysisModel;
    }

    public OrmInput[] buildAlgoX(DerivationBusinessDTO derivationBusinessDTO, LogConfigDTO execConfig) {
        String entityNumber = PACommonConstans.buildEntityName((String)this.analysisModel.getString("tablenumber"));
        String fields = this.getFields();
        QFilter excludeOrgQFilter = this.getQFilterExcludeOrg(execConfig);
        logger.info(String.format("[FI-PA]DerivationSenderBuildExecutor BuildAlgoX success! entityNumber:%s, fields:%s, qFilter:%s", entityNumber, fields, excludeOrgQFilter));
        int maxOrgInputCount = PACustomParamHelper.getMaxOrgInputCount();
        String orgDimNumber = derivationBusinessDTO.getModelConfigDTO().getOrgDimNumber();
        QFilter[] includeOrgQFilters = PAFilterHelper.splitQFilters((QFilter)excludeOrgQFilter, (String)orgDimNumber, (Object[])execConfig.getOrgIds().toArray(new Long[0]), (int)maxOrgInputCount);
        ArrayList<OrmInput> ormInputList = new ArrayList<OrmInput>(includeOrgQFilters.length);
        for (QFilter qFilter : includeOrgQFilters) {
            ormInputList.add(new OrmInput(ALGO, entityNumber, fields, qFilter.toArray()));
        }
        return ormInputList.toArray(new OrmInput[0]);
    }

    private String getFields() {
        HashSet<String> fieldSet = new HashSet<String>();
        List<String> modelFieldList = ModelUtil.getModelFieldList(this.analysisModel);
        fieldSet.addAll(modelFieldList);
        ArrayList<String> extraFieldList = new ArrayList<String>();
        String derivationMode = this.derivationRule.getDerivationMode();
        DerivationTypeEnum derivationTypeEnum = DerivationTypeEnum.getDerivationTypeEnum((String)derivationMode);
        switch (derivationTypeEnum) {
            case DERIVATION_MAPPING_TABLE: {
                DynamicObjectCollection sourceEntryEntity = this.derivationRule.getMtSourceEntryEntity();
                for (Object dy : sourceEntryEntity) {
                    DynamicObject sourceDy = dy.getDynamicObject("mt_source");
                    String type = sourceDy.getString("dimensiontype");
                    String number = sourceDy.getString("number");
                    String mtSourceFieldNumber = dy.getString("mt_sourcefield_number");
                    DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)type);
                    if (DimensionTypeEnum.DATABASE != dimensionTypeEnum && DimensionTypeEnum.ASSISTANTDATA != dimensionTypeEnum) continue;
                    String sourceField = number + "." + mtSourceFieldNumber;
                    String sourceFieldFormat = FieldUtil.modelFormatAlias(sourceField);
                    extraFieldList.add(sourceFieldFormat);
                }
                DynamicObjectCollection targetEntryEntity = this.derivationRule.getMtTargetEntryEntity();
                for (DynamicObject dy : targetEntryEntity) {
                    DynamicObject targetDy = dy.getDynamicObject("mt_target");
                    String type = targetDy.getString("dimensiontype");
                    String number = targetDy.getString("number");
                    String mtTargetFieldNumber = dy.getString("mt_targetfield_number");
                    DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)type);
                    if (DimensionTypeEnum.DATABASE != dimensionTypeEnum && DimensionTypeEnum.ASSISTANTDATA != dimensionTypeEnum) continue;
                    String targetField = number + "." + mtTargetFieldNumber;
                    String targetFieldFormat = FieldUtil.modelFormatAlias(targetField);
                    extraFieldList.add(targetFieldFormat);
                }
                break;
            }
            case DERIVATION_MAPPING_RELATIONSHIP: {
                break;
            }
            case DERIVATION_CUSTOM: {
                Set dimFieldSet = PAAnalysisModelHelper.getDimFieldSet((Long)this.analysisModel.getLong("id"));
                extraFieldList.addAll(dimFieldSet);
                Set dimPKFieldSet = PAAnalysisModelHelper.getDimPkFieldSet((Set)dimFieldSet);
                extraFieldList.addAll(dimPKFieldSet);
                break;
            }
        }
        fieldSet.addAll(extraFieldList);
        return String.join((CharSequence)",", fieldSet);
    }

    private QFilter getQFilterExcludeOrg(LogConfigDTO execConfig) {
        QFilter qFilter = new QFilter("datastatus", "=", (Object)DataStatusEnum.SOURCE.getLongCode()).and(new QFilter("collectstatus", "=", (Object)OperationStatusEnum.USED.getLongCode())).and(new QFilter("situationtype", "=", (Object)PASituationTypeEnum.ACTUAL.getLongCode()));
        this.processQFilterByDimEntryExcludeOrg(qFilter, execConfig);
        this.processQFilterBySenderEntry(qFilter);
        return qFilter;
    }

    private void processQFilterByDimEntryExcludeOrg(QFilter qFilter, LogConfigDTO execConfig) {
        DynamicObjectCollection senderEntry = this.derivationRule.getSendEntryEntity();
        DynamicObjectCollection dimensionEntry = this.analysisModel.getDynamicObjectCollection("dimension_entry");
        boolean sendDimContainsAccount = false;
        DynamicObject accountDynamicObject = dimensionEntry.stream().filter(dy -> StringUtils.equals((CharSequence)DimensionNecessityEnum.ACCOUNT.getCode(), (CharSequence)dy.getString("necessity_dim"))).findFirst().orElse(null);
        if (accountDynamicObject != null) {
            String accountNumber = accountDynamicObject.getDynamicObject("dimension").getString("number");
            for (DynamicObject sendDynamicObject : senderEntry) {
                if (!StringUtils.equals((CharSequence)accountNumber, (CharSequence)sendDynamicObject.getDynamicObject("senddimension").getString("number"))) continue;
                sendDimContainsAccount = true;
            }
        }
        Long periodId = execConfig.getPeriod();
        Set<Long> accountIdSet = execConfig.getAccountIdSet();
        Date startDate = execConfig.getStartDate();
        Date endDate = execConfig.getEndDate();
        for (DynamicObject dim : dimensionEntry) {
            String number = dim.getDynamicObject("dimension").getString("number");
            DimensionNecessityEnum necessityEnum = DimensionNecessityEnum.getEnum((String)dim.getString("necessity_dim"));
            if (necessityEnum == null) continue;
            switch (necessityEnum) {
                case ORG: {
                    break;
                }
                case PERIOD: {
                    if (Objects.isNull(periodId)) {
                        PAExecutorHelper.processTimeDimFilter((QFilter)qFilter, (String)number, (Date)startDate, (Date)endDate);
                        break;
                    }
                    PAExecutorHelper.processCommonFilter((QFilter)qFilter, (String)number, (Object)periodId);
                    break;
                }
                case ACCOUNT: {
                    if (sendDimContainsAccount) break;
                    PAExecutorHelper.processCommonFilter((QFilter)qFilter, (String)number, accountIdSet);
                    break;
                }
            }
        }
    }

    private void processQFilterBySenderEntry(QFilter qFilter) {
        DynamicObjectCollection senderEntry = this.derivationRule.getSendEntryEntity();
        for (DynamicObject sendDynamicObject : senderEntry) {
            String number = sendDynamicObject.getString("senddimension.number");
            String type = sendDynamicObject.getString("senddimension.dimensiontype");
            String sendCondition = sendDynamicObject.getString("combofield");
            String text = sendDynamicObject.getString("dimensiontext_tag");
            String baseEntityId = sendDynamicObject.getString("dimensiontype_basedata");
            String value = "";
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)sendCondition);
            if (conditionEnum == FilterConditionEnum.IN || conditionEnum == FilterConditionEnum.NOT_IN) {
                value = ModelUtil.getDimValue(type, text);
            }
            QFilter dimQFilter = ModelUtil.getDimQFilter(type, number, baseEntityId, sendCondition, value);
            qFilter.and(dimQFilter);
        }
    }
}

