/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.AdExecutionLogDTO;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.dto.ExecutionResultAdjustEntryDTO;
import kd.fi.pa.engine.action.AdjustAction;
import kd.fi.pa.engine.action.IPaAction;
import kd.fi.pa.engine.action.OnceWriteOffAction;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.model.AdjustRule;
import kd.fi.pa.engine.model.IRule;
import kd.fi.pa.engine.service.RuleServiceFactory;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.WriteOffTypeEnum;
import kd.fi.pa.helper.PALogHelper;

public class PaExecutor {
    public static final Log logger = LogFactory.getLog(PaExecutor.class);

    public void execute(ExecutionLogDTO executionLog) {
        logger.info("[FI-PA] Debug Execute execute begin");
        Long lodId = executionLog.getId();
        ExecutorLog log = ExecutorLog.getInstance();
        log.setLogId(lodId);
        ExecutionModeEnum executionMode = executionLog.getExecutionMode();
        switch (executionMode) {
            case writeOff: {
                char writeOffType = executionLog.getWriteOffType();
                if (WriteOffTypeEnum.SINGLE_RULE.getCode() != writeOffType && WriteOffTypeEnum.SINGLE_ADJUST.getCode() != writeOffType) break;
                this.onceWriteOffExecute(executionLog, log);
                break;
            }
            case adjust: {
                this.adjustExecute(executionLog, log);
                break;
            }
        }
        logger.info("[FI-PA] Debug Execute execute end");
    }

    private void calData(Long analysisModelId, String errorTips) {
        try {
            DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFFetchDataScheduleService", (String)"calculateModelLazyTask", (Object[])new Object[]{analysisModelId});
        }
        catch (Exception ex) {
            logger.error(String.format("[FI-PA] %s\uff1asummary calculate error, analysisModelId\uff1a%d", errorTips, analysisModelId), (Throwable)ex);
        }
    }

    public void onceWriteOffExecute(ExecutionLogDTO executionLog, ExecutorLog log) {
        try (TXHandle h = TX.required((String)"onceWriteOffExecute");){
            long beginTime = System.currentTimeMillis();
            try {
                IRule rule = RuleServiceFactory.getWriteOffRuleOnce().createModel(executionLog);
                new OnceWriteOffAction().execute(rule, log);
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    logger.error("[FI-PA] OnceWriteOff execute error, data rolled back", (Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("fi.pa.business.executor.onceWriteOff", e.getMessage()), new Object[0]);
                }
                catch (Throwable throwable) {
                    long endTime = System.currentTimeMillis();
                    logger.info(String.format("[FI-PA] OnceWriteOffExecute time consuming %d", endTime - beginTime));
                    throw throwable;
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info(String.format("[FI-PA] OnceWriteOffExecute time consuming %d", endTime - beginTime));
        }
        this.calData(executionLog.getAnalysisModel(), "onceWriteOffExecute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustExecute(ExecutionLogDTO executionLog, ExecutorLog log) {
        long beginTime = System.currentTimeMillis();
        List businessIdList = executionLog.getBusinessIdList();
        ArrayList<ExecutionResultAdjustEntryDTO> adjustEntryDTOList = new ArrayList<ExecutionResultAdjustEntryDTO>(businessIdList.size());
        long[] adjustLogIdArr = DB.genGlobalLongIds((int)businessIdList.size());
        Exception exc = null;
        for (int i = 0; i < businessIdList.size(); ++i) {
            Long businessId = (Long)businessIdList.get(i);
            long adjustLogId = adjustLogIdArr[i];
            try {
                log.setRuleExecutionLogId(adjustLogId);
                AdExecutionLogDTO dto = new AdExecutionLogDTO(Long.valueOf(adjustLogId), executionLog.getId(), businessId, PASyncLogStatusEnum.SUCCESS, new Date(), null, null);
                dto.setDetailTime(Long.valueOf(System.currentTimeMillis()));
                PALogHelper.createAdExecutionSingleLog((AdExecutionLogDTO)dto);
                IRule adjustRule = RuleServiceFactory.getAdjustRule().createModel(businessId);
                IPaAction currentAction = this.createAction(adjustRule);
                if (currentAction == null) continue;
                currentAction.execute(adjustRule, log);
                continue;
            }
            catch (Exception e) {
                logger.error("[FI-PA] Adjust execute error, data rolled back", (Throwable)e);
                PALogHelper.updateExecuteAdjustLogStatus((Object)adjustLogId, (String)PASyncLogStatusEnum.FAILURE.getCodeString());
                exc = e;
                continue;
            }
            finally {
                adjustEntryDTOList.add(new ExecutionResultAdjustEntryDTO(businessId));
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("[FI-PA] AdjustExecute time consuming %d", endTime - beginTime));
        try {
            PALogHelper.createResultAdjustEntry((Object)log.getLogId(), adjustEntryDTOList);
        }
        catch (Exception ex) {
            logger.error("[FI-PA] save result adjust entry error", (Throwable)ex);
        }
        if (exc != null) {
            throw new KDBizException((Throwable)exc, new ErrorCode("fi.pa.business.executor.adjustExecute", exc.getMessage()), new Object[0]);
        }
    }

    private IPaAction createAction(IRule rule) {
        if (rule instanceof AdjustRule) {
            return new AdjustAction();
        }
        return null;
    }
}

