/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor.allocation;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.util.CollectionUtils;

public interface TailDifferenceProcessor
extends Serializable {
    default public BigDecimal calculateTailDifference(List<BigDecimal> receiverRates, List<BigDecimal> receiverAmts, BigDecimal totalAmt) {
        if (CollectionUtils.isEmpty(receiverRates) || CollectionUtils.isEmpty(receiverAmts) || receiverRates.size() != receiverAmts.size() || totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal allocatedAmt = BigDecimal.ZERO;
        for (int i = 0; i < receiverRates.size(); ++i) {
            BigDecimal receiverAmt = receiverAmts.get(i);
            if (receiverAmt == null) continue;
            allocatedAmt = allocatedAmt.add(receiverAmt);
        }
        return totalAmt.subtract(allocatedAmt);
    }

    default public int getTailDifferenceReceiverIndex(List<BigDecimal> receiverRates) {
        return -1;
    }

    default public void sortReceiverList(List<Map<String, String>> receiverList) {
    }
}

