/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor.allocation.receiver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.pa.engine.executor.allocation.receiver.ShareReceiverProcessor;

public abstract class AbstractShareReceiverProcessor
implements ShareReceiverProcessor {
    public List<String> parseReceiverDimNums(DynamicObjectCollection receiverEntry) {
        if (receiverEntry == null) {
            return new ArrayList<String>(0);
        }
        return receiverEntry.stream().map(dy -> dy.getDynamicObject("receivedimension").getString("number")).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<Map<String, Object>> parseReceiverLimit(DynamicObjectCollection receiverLimitEntry) {
        if (receiverLimitEntry == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> receiverLimitList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dy : receiverLimitEntry) {
            Map receiverLimitMap = (Map)SerializationUtils.fromJsonString((String)dy.getString("subvaluelimit_tag"), Map.class);
            HashMap dimValueMap = new HashMap(16);
            for (Map.Entry entry : receiverLimitMap.entrySet()) {
                String dimNum = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf("_"));
                dimValueMap.put(dimNum, entry.getValue());
            }
            receiverLimitList.add(dimValueMap);
        }
        return receiverLimitList;
    }

    public List<Map<String, Object>> parseReceiverDetail(DynamicObjectCollection receiverDetailEntry) {
        if (receiverDetailEntry == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> receiverDetailList = new ArrayList<Map<String, Object>>(receiverDetailEntry.size());
        for (DynamicObject dy : receiverDetailEntry) {
            HashMap dimValueMap = new HashMap(16);
            Map receiverDetailMap = (Map)SerializationUtils.fromJsonString((String)dy.getString("subvalue_tag"), Map.class);
            for (Map.Entry entry : receiverDetailMap.entrySet()) {
                dimValueMap.put(((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf("_")), entry.getValue());
            }
            receiverDetailList.add(dimValueMap);
        }
        return receiverDetailList;
    }
}

