/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor.allocation.receiver;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.executor.allocation.receiver.AbstractShareReceiverProcessor;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.engine.warpper.ReceiverRelateGroupWrapper;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.enums.OperationStatusEnum;
import kd.fi.pa.enums.PASituationTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class ShareAccountReceiverProcessor
extends AbstractShareReceiverProcessor {
    private static final Log logger = LogFactory.getLog(ShareAccountReceiverProcessor.class);
    private static final String ALGO = ShareAccountReceiverProcessor.class.getName();

    @Override
    public List<Map<String, String>> buildReceivers(AllocationRule allocationRule, LogConfigDTO execConfig) {
        List<Map<String, String>> receiverList;
        DynamicObjectCollection receiverEntry = allocationRule.getReceiverEntry();
        HashSet<String> recvDimNums = new HashSet<String>(this.parseReceiverDimNums(receiverEntry));
        try (DataSet resultDataSet = this.getModelResultDataSet(allocationRule, execConfig);){
            Set<String> groupDimNums = allocationRule.getRelatedGroupDimNums();
            String groupMeasureNum = allocationRule.getMeasure().getString("number");
            receiverList = this.buildReceiverDataAndRate(resultDataSet, groupMeasureNum, groupDimNums, recvDimNums);
        }
        return receiverList;
    }

    private List<Map<String, String>> buildReceiverDataAndRate(DataSet resultDataSet, String groupMeasureNum, Set<String> groupDimNums, Set<String> recvDimNums) {
        ArrayList<Map<String, Object>> originReceiverDatas = new ArrayList<Map<String, Object>>(16);
        HashSet<String> recvGroupDimNums = new HashSet<String>(groupDimNums);
        recvGroupDimNums.addAll(recvDimNums);
        BigDecimal totalAmount = BigDecimal.ZERO;
        try (DataSet detailResultDataSet = resultDataSet.groupBy(recvGroupDimNums.toArray(new String[0])).sum(groupMeasureNum).finish();){
            for (Row row : detailResultDataSet) {
                BigDecimal oneMeasure = row.getBigDecimal(groupMeasureNum);
                totalAmount = totalAmount.add(oneMeasure);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("factorValue", oneMeasure);
                for (String fieldName : recvGroupDimNums) {
                    map.put(fieldName, String.valueOf(row.get(fieldName)));
                }
                originReceiverDatas.add(map);
            }
        }
        ReceiverRelateGroupWrapper receiverRelateGroupWrapper = new ReceiverRelateGroupWrapper(groupDimNums);
        return receiverRelateGroupWrapper.buildRate(originReceiverDatas, new ArrayList<String>(recvGroupDimNums), totalAmount);
    }

    private DataSet getModelResultDataSet(AllocationRule allocationRule, LogConfigDTO execConfig) {
        String entityNumber = AnalysisModelUtil.buildEntityNumber((String)allocationRule.getAnalysisModel().getString("tablenumber"));
        List<String> modelFields = this.getModelFields(allocationRule);
        QFilter modelQFilter = this.getModelQFilter(allocationRule, execConfig);
        DataSet receiverDataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityNumber, (String)String.join((CharSequence)",", modelFields), (QFilter[])new QFilter[]{modelQFilter}, null);
        List<Map<String, Object>> receiverLimitList = this.parseReceiverLimit(allocationRule.getReceiverLimitEntry());
        return this.filterDimValueByReceiverLimit(receiverDataSet, receiverLimitList, allocationRule.getLimitType());
    }

    private List<String> getModelFields(AllocationRule allocationRule) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(16);
        fields.addAll(this.parseReceiverDimNums(allocationRule.getReceiverEntry()));
        fields.addAll(allocationRule.getRelatedGroupDimNums());
        String groupMeasureNum = allocationRule.getMeasure().getString("number");
        fields.add(groupMeasureNum);
        return new ArrayList<String>(fields);
    }

    private QFilter getModelQFilter(AllocationRule allocationRule, LogConfigDTO execConfig) {
        Set<Object> accountIdSet = this.getAccountIdSet(allocationRule);
        QFilter qFilter = new QFilter("datastatus", "=", (Object)DataStatusEnum.SOURCE.getLongCode()).and(new QFilter("collectstatus", "=", (Object)OperationStatusEnum.USED.getLongCode())).and(new QFilter("situationtype", "=", (Object)PASituationTypeEnum.ACTUAL.getLongCode()));
        ArrayList<Long> orgIds = MultiOrgShareEnum.NO == allocationRule.getMultiOrgShare() ? execConfig.getOrgIds() : null;
        QFilter orgPeriodAccountQFilter = PAExecutorHelper.buildOrgPeriodAccountQFilter((DynamicObject)allocationRule.getAnalysisModel(), orgIds, (Long)execConfig.getPeriod(), (Date)execConfig.getStartDate(), (Date)execConfig.getEndDate(), accountIdSet);
        QFilter receiverQFilter = this.buildQFilterOfReceiverEntry(allocationRule.getReceiverEntry());
        return qFilter.and(orgPeriodAccountQFilter).and(receiverQFilter);
    }

    private QFilter buildQFilterOfReceiverEntry(DynamicObjectCollection receiverEntry) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (DynamicObject dy : receiverEntry) {
            String type = dy.getString("receivedimtype");
            String number = dy.getDynamicObject("receivedimension").getString("number");
            String receiveCondition = dy.getString("comboreceive");
            String idStr = dy.getString("receivedimid");
            String valueStr = dy.getString("receivedimvalue");
            String text = dy.getString("receivedimensiontext_tag");
            String baseEntityId = dy.getString("receivematename");
            String value = "";
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)receiveCondition);
            if (conditionEnum == FilterConditionEnum.IN || conditionEnum == FilterConditionEnum.NOT_IN) {
                value = ModelUtil.getDimValue(type, text, idStr, valueStr);
            }
            QFilter dimQFilter = ModelUtil.getDimQFilter(type, number, baseEntityId, receiveCondition, value);
            qFilter.and(dimQFilter);
        }
        return qFilter;
    }

    private Set<Object> getAccountIdSet(AllocationRule allocationRule) {
        DynamicObjectCollection dimensionEntry = allocationRule.getAnalysisModel().getDynamicObjectCollection("dimension_entry");
        String accountFilterStr = allocationRule.getAccountFilter();
        long accountDimId = 0L;
        for (DynamicObject dim : dimensionEntry) {
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(dim.getString("necessity_dim"))) continue;
            accountDimId = dim.getLong("dimension_id");
        }
        DynamicObject accountDimDynamicObject = PADimensionHelper.loadDimension((Object)accountDimId);
        if (Objects.isNull(accountDimDynamicObject)) {
            logger.error("[FI-PA]ReceiverBuildExecutor Build account is null");
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "account is null");
        }
        String accountEntityName = accountDimDynamicObject.getDynamicObject("dimensionsource").getPkValue().toString();
        String filterJson = accountFilterStr.replace(accountDimDynamicObject.getString("number") + ".", "");
        QFilter accountFilter = this.getQFilterFromFilterCondition(filterJson, accountEntityName);
        QFilter dimensionTypeQFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)accountDimDynamicObject);
        return BusinessDataServiceHelper.loadFromCache((String)accountEntityName, (QFilter[])new QFilter[]{accountFilter, dimensionTypeQFilter}).keySet();
    }

    private QFilter getQFilterFromFilterCondition(String filterJson, String entityNumber) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumber), filterCondition);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    private DataSet filterDimValueByReceiverLimit(DataSet receiverDataSet, List<Map<String, Object>> receiverLimitList, String limitType) {
        if (receiverLimitList.isEmpty()) {
            return receiverDataSet;
        }
        if ("1".equals(limitType)) {
            return receiverDataSet.filter(this.includeReceiverLimit(receiverLimitList));
        }
        if ("0".equals(limitType)) {
            return receiverDataSet.filter(this.excludeReceiverLimit(receiverLimitList));
        }
        return receiverDataSet;
    }

    private FilterFunction includeReceiverLimit(final List<Map<String, Object>> receiverLimitList) {
        return new FilterFunction(){

            public boolean test(Row row) {
                for (Map limitRowMap : receiverLimitList) {
                    boolean isMatch = true;
                    for (Map.Entry limitValueEntry : limitRowMap.entrySet()) {
                        String factorDimValue;
                        String dimNum = (String)limitValueEntry.getKey();
                        String limitValue = String.valueOf(limitValueEntry.getValue());
                        if (limitValue.equals(factorDimValue = String.valueOf(row.get(dimNum)))) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private FilterFunction excludeReceiverLimit(final List<Map<String, Object>> receiverLimitList) {
        return new FilterFunction(){

            public boolean test(Row row) {
                for (Map limitRowMap : receiverLimitList) {
                    boolean isExclude = true;
                    for (Map.Entry limitValueEntry : limitRowMap.entrySet()) {
                        String factorDimValue;
                        String dimNum = (String)limitValueEntry.getKey();
                        String limitValue = String.valueOf(limitValueEntry.getValue());
                        if (limitValue.equals(factorDimValue = String.valueOf(row.get(dimNum)))) continue;
                        isExclude = false;
                        break;
                    }
                    if (!isExclude) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

