/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor.allocation.receiver;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.engine.executor.allocation.receiver.AbstractShareReceiverProcessor;
import kd.fi.pa.engine.model.AllocationRule;
import kd.fi.pa.engine.warpper.ReceiverRelateGroupWrapper;
import kd.fi.pa.enginealgox.model.config.LogConfigDTO;
import kd.fi.pa.enginealgox.utils.ModelUtil;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.ShareFactorTypeEnum;
import kd.fi.pa.model.impl.PADimensionModel;

public class ShareFactorReceiverProcessor
extends AbstractShareReceiverProcessor {
    @Override
    public List<Map<String, String>> buildReceivers(AllocationRule allocationRule, LogConfigDTO execConfig) {
        DynamicObject shareFactor = BusinessDataServiceHelper.loadSingle((Object)allocationRule.getShareFactor().getPkValue(), (String)"pa_sharefactor");
        String shareFactorType = shareFactor.getString("factortype");
        DynamicObjectCollection receiverEntry = allocationRule.getReceiverEntry();
        List<String> recvDimNums = this.parseReceiverDimNums(receiverEntry);
        if (ShareFactorTypeEnum.PERIOD.getCode().equals(shareFactorType)) {
            recvDimNums.add(0, "period_my");
        }
        Map<String, Function<String, Boolean>> filterFunction = this.buildShareFactorFilterFunction(receiverEntry, execConfig.getPeriod(), shareFactorType);
        Map<String, Object> shareFactorValueMap = this.parseShareFactorValue(shareFactor);
        Tuple<List<Map<String, Object>>, BigDecimal> tupleResult = this.buildShareFactorValueList(recvDimNums, filterFunction, shareFactorType, shareFactorValueMap, allocationRule);
        if (((List)tupleResult.item1).isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ReceiverRelateGroupWrapper receiverRelateGroupWrapper = new ReceiverRelateGroupWrapper(allocationRule.getRelatedGroupDimNums());
        List<Map<String, String>> receiverList = receiverRelateGroupWrapper.buildRate((List)tupleResult.item1, recvDimNums, (BigDecimal)tupleResult.item2);
        if (ShareFactorTypeEnum.PERIOD.getCode().equals(shareFactorType)) {
            receiverList.forEach(receiverMap -> {
                String cfr_ignored_0 = (String)receiverMap.remove("period_my");
            });
        }
        return receiverList;
    }

    private Map<String, Object> parseShareFactorValue(DynamicObject shareFactor) {
        DynamicObjectCollection shareFactorEntry = shareFactor.getDynamicObjectCollection("share_factor_entry");
        LinkedHashMap<String, Object> shareFactorMap = new LinkedHashMap<String, Object>(shareFactorEntry.size() * 2);
        for (DynamicObject dy : shareFactorEntry) {
            shareFactorMap.put(dy.getString("value_pks_tag"), dy.get("value"));
        }
        return shareFactorMap;
    }

    private List<Map<String, Object>> parseReceiverLimit(DynamicObjectCollection receiverLimitEntry, String shareFactorType) {
        List<Map<String, Object>> receiverLimitList = this.parseReceiverLimit(receiverLimitEntry);
        if (ShareFactorTypeEnum.PERIOD.getCode().equals(shareFactorType)) {
            for (Map<String, Object> receiverLimit : receiverLimitList) {
                if (!receiverLimit.containsKey("period")) continue;
                Object sharePeriod = receiverLimit.remove("period");
                receiverLimit.put("period_my", sharePeriod);
            }
        }
        return receiverLimitList;
    }

    private Map<String, Function<String, Boolean>> buildShareFactorFilterFunction(DynamicObjectCollection receiverEntry, Long currentPeriodId, String shareFactorType) {
        HashMap<String, Function<String, Boolean>> filterFunction = new HashMap<String, Function<String, Boolean>>(16);
        if (ShareFactorTypeEnum.PERIOD.getCode().equals(shareFactorType)) {
            filterFunction.put("period_my", periodValue -> String.valueOf(currentPeriodId).equals(periodValue));
        }
        for (DynamicObject dynamicObject : receiverEntry) {
            String dimName = dynamicObject.getDynamicObject("receivedimension").getString("number");
            String receiveCondition = dynamicObject.getString("comboreceive");
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)receiveCondition);
            switch (conditionEnum) {
                case IN: {
                    String type = dynamicObject.getString("receivedimtype");
                    String idStr = dynamicObject.getString("receivedimid");
                    String valueStr = dynamicObject.getString("receivedimvalue");
                    String text = dynamicObject.getString("receivedimensiontext_tag");
                    String value = ModelUtil.getDimValue(type, text, idStr, valueStr) + ',';
                    filterFunction.put(dimName, idOrStr -> {
                        String re = String.valueOf(idOrStr) + ',';
                        return value.contains(re);
                    });
                    break;
                }
                case ALL: {
                    filterFunction.put(dimName, idOrStr -> true);
                    break;
                }
                case IS_NOTNULL: {
                    String baseEntityId = dynamicObject.getString("receivematename");
                    boolean isString = PADimensionModel.isStringPrimaryKeyType((String)baseEntityId);
                    filterFunction.put(dimName, idOrStr -> isString ? StringUtils.isNotEmpty((CharSequence)idOrStr) : idOrStr != null && Long.parseLong(idOrStr) != 0L);
                }
            }
        }
        return filterFunction;
    }

    private Tuple<List<Map<String, Object>>, BigDecimal> buildShareFactorValueList(List<String> recvDimNums, Map<String, Function<String, Boolean>> filterFunction, String shareFactorType, Map<String, Object> shareFactorValueMap, AllocationRule allocationRule) {
        ArrayList<HashMap<String, Object>> factorValueList = new ArrayList<HashMap<String, Object>>(16);
        BigDecimal total = BigDecimal.ZERO;
        List<Map<String, Object>> receiverLimitList = this.parseReceiverLimit(allocationRule.getReceiverLimitEntry(), shareFactorType);
        for (Map.Entry<String, Object> keyValueEntry : shareFactorValueMap.entrySet()) {
            String dimValues = keyValueEntry.getKey();
            Object factorValue = keyValueEntry.getValue();
            HashMap<String, Object> dimValueMap = new HashMap<String, Object>(16);
            if (!this.filterShareFactorValueByReceiverCondition(dimValues, recvDimNums, filterFunction, dimValueMap) || !this.filterDimValueByReceiverLimit(receiverLimitList, dimValueMap, allocationRule.getLimitType())) continue;
            dimValueMap.put("factorValue", factorValue);
            total = total.add((BigDecimal)factorValue);
            factorValueList.add(dimValueMap);
        }
        if (BigDecimal.ZERO.compareTo(total) == 0) {
            return Tuple.create(new ArrayList(0), (Object)total);
        }
        return Tuple.create(factorValueList, (Object)total);
    }

    private boolean filterShareFactorValueByReceiverCondition(String dimValues, List<String> recvDimNums, Map<String, Function<String, Boolean>> filterFunction, Map<String, Object> dimValueMap) {
        String[] dimPKValues = dimValues.split(",");
        for (int index = 0; index < dimPKValues.length; ++index) {
            String dimValueStr = dimPKValues[index];
            String fieldName = recvDimNums.get(index);
            boolean fieldMatch = filterFunction.get(fieldName).apply(dimValueStr);
            if (!fieldMatch) {
                return false;
            }
            dimValueMap.put(fieldName, dimValueStr);
        }
        return true;
    }

    private boolean filterDimValueByReceiverLimit(List<Map<String, Object>> receiverLimitList, Map<String, Object> dimValueMap, String limitType) {
        if (receiverLimitList.isEmpty()) {
            return true;
        }
        if ("1".equals(limitType)) {
            return this.includeReceiverLimit(receiverLimitList, dimValueMap);
        }
        if ("0".equals(limitType)) {
            return this.excludeReceiverLimit(receiverLimitList, dimValueMap);
        }
        return true;
    }

    private boolean includeReceiverLimit(List<Map<String, Object>> receiverLimitList, Map<String, Object> dimValueMap) {
        for (Map<String, Object> limitRowMap : receiverLimitList) {
            boolean isMatch = true;
            for (Map.Entry<String, Object> limitValueEntry : limitRowMap.entrySet()) {
                String factorDimValue;
                String dimNum = limitValueEntry.getKey();
                String limitValue = String.valueOf(limitValueEntry.getValue());
                if (limitValue.equals(factorDimValue = String.valueOf(dimValueMap.get(dimNum)))) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean excludeReceiverLimit(List<Map<String, Object>> receiverLimitList, Map<String, Object> dimValueMap) {
        for (Map<String, Object> limitRowMap : receiverLimitList) {
            boolean isExclude = true;
            for (Map.Entry<String, Object> limitValueEntry : limitRowMap.entrySet()) {
                String factorDimValue;
                String dimNum = limitValueEntry.getKey();
                String limitValue = String.valueOf(limitValueEntry.getValue());
                if (limitValue.equals(factorDimValue = String.valueOf(dimValueMap.get(dimNum)))) continue;
                isExclude = false;
                break;
            }
            if (!isExclude) continue;
            return false;
        }
        return true;
    }
}

