/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.executor.allocation.receiver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.engine.executor.allocation.receiver.ShareAccountReceiverProcessor;
import kd.fi.pa.engine.executor.allocation.receiver.ShareFactorReceiverProcessor;
import kd.fi.pa.engine.executor.allocation.receiver.ShareFixedReceiverProcessor;
import kd.fi.pa.engine.executor.allocation.receiver.ShareReceiverProcessor;

public class ShareReceiverProcessorFactory {
    private static final Map<ShareTypeEnum, ShareReceiverProcessor> processorMap = new ConcurrentHashMap<ShareTypeEnum, ShareReceiverProcessor>(4){
        {
            this.put(ShareTypeEnum.SHARE_FIXED, new ShareFixedReceiverProcessor());
            this.put(ShareTypeEnum.SHARE_FACTOR, new ShareFactorReceiverProcessor());
            this.put(ShareTypeEnum.SHARE_SUBJECT, new ShareAccountReceiverProcessor());
        }
    };

    public static ShareReceiverProcessor createProcessor(ShareTypeEnum shareType) {
        if (shareType == null) {
            return null;
        }
        return processorMap.get(shareType);
    }
}

