/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.lock;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.engine.lock.ModelLockType;
import kd.fi.pa.helper.DLockHelper;
import kd.fi.pa.helper.SystemParamHelper;

public final class ModelTaskLock {
    private static final Log logger = LogFactory.getLog(ModelTaskLock.class);
    private String detailEntityNum;
    private Long modelId;
    private Long[] orgIds;
    private Long periodId;
    private final Map<String, DLock> dLockMap = new HashMap<String, DLock>(16);
    private ModelLockType lockType = ModelLockType.MODEL;

    private ModelTaskLock() {
    }

    public static ModelTaskLock create(String detailEntityNum, Long modelId) {
        if (StringUtils.isEmpty((CharSequence)detailEntityNum) || modelId == null) {
            throw new KDBizException("DLock params is invalid");
        }
        ModelTaskLock lock = new ModelTaskLock();
        lock.detailEntityNum = detailEntityNum;
        lock.modelId = modelId;
        lock.lockType = ModelLockType.MODEL;
        lock.init();
        return lock;
    }

    public static ModelTaskLock create(String detailEntityNum, Long modelId, Long[] orgIds, Long periodId) {
        if (StringUtils.isEmpty((CharSequence)detailEntityNum) || modelId == null) {
            throw new KDBizException("DLock params is invalid");
        }
        ModelTaskLock lock = new ModelTaskLock();
        lock.detailEntityNum = detailEntityNum;
        lock.modelId = modelId;
        lock.orgIds = orgIds;
        lock.periodId = periodId;
        int orgCountThreshold = SystemParamHelper.getModelLockOrgThreshold();
        lock.lockType = orgIds != null && orgIds.length <= orgCountThreshold && periodId != null && periodId != 0L ? ModelLockType.ORG_PERIOD : ModelLockType.MODEL;
        lock.init();
        return lock;
    }

    private void init() {
        if (ModelLockType.ORG_PERIOD == this.lockType) {
            Map<Long, String> lockKeyMap = this.getOrgPeriodLockKey();
            for (String lockKey : lockKeyMap.values()) {
                this.dLockMap.put(lockKey, DLock.create((String)lockKey, (String)lockKey));
            }
        } else if (ModelLockType.MODEL == this.lockType) {
            String lockKey = this.getModelLockKey();
            this.dLockMap.put(lockKey, DLock.create((String)lockKey, (String)lockKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long timeoutMillis) {
        if (ModelLockType.ORG_PERIOD == this.lockType) {
            boolean success = true;
            long start = System.currentTimeMillis();
            try {
                for (Map.Entry<String, DLock> entry : this.dLockMap.entrySet()) {
                    if (this.doLock(entry.getValue(), start + timeoutMillis - System.currentTimeMillis())) continue;
                    success = false;
                    break;
                }
                if (success && DLockHelper.existsMLock((String)this.detailEntityNum)) {
                    success = false;
                }
            }
            finally {
                if (!success) {
                    this.unlock();
                }
            }
            return success;
        }
        if (ModelLockType.MODEL == this.lockType) {
            boolean success = false;
            String modelLockKey = this.getModelLockKey();
            try {
                if (this.doLock(this.dLockMap.get(modelLockKey), timeoutMillis) && !DLockHelper.existsMOPLock((Long)this.modelId)) {
                    success = true;
                }
            }
            finally {
                if (!success) {
                    this.unlock();
                }
            }
            return success;
        }
        return false;
    }

    private boolean doLock(DLock lock, long remain) {
        if (lock == null || remain <= 0L) {
            return false;
        }
        return lock.tryLock(remain);
    }

    public boolean existsLock() {
        return this.existsLock(null);
    }

    public boolean existsLock(List<Long> lockedOrgIds) {
        String modelLockKey;
        Set allLockKeySet = DLock.getAllLockInfo().keySet();
        if (allLockKeySet.contains(modelLockKey = this.getModelLockKey())) {
            return true;
        }
        boolean anyOrgLocked = false;
        Map<Long, String> lockKeyMap = this.getOrgPeriodLockKey();
        for (Map.Entry<Long, String> entrySet : lockKeyMap.entrySet()) {
            if (!allLockKeySet.contains(entrySet.getValue())) continue;
            anyOrgLocked = true;
            if (lockedOrgIds == null) continue;
            lockedOrgIds.add(entrySet.getKey());
        }
        if (anyOrgLocked) {
            return true;
        }
        if (ModelLockType.MODEL == this.lockType) {
            String orgPeriodLockKeyPrefix = DLockHelper.getMOPLockKeyPrefix((Long)this.modelId);
            for (String lockedKey : allLockKeySet) {
                if (!lockedKey.startsWith(orgPeriodLockKeyPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private String getModelLockKey() {
        return DLockHelper.getMLockKey((String)this.detailEntityNum);
    }

    private Map<Long, String> getOrgPeriodLockKey() {
        if (ModelLockType.ORG_PERIOD != this.lockType) {
            return new HashMap<Long, String>(0);
        }
        LinkedHashMap<Long, String> lockKeyMap = new LinkedHashMap<Long, String>(16);
        for (Long orgId : this.orgIds) {
            lockKeyMap.put(orgId, DLockHelper.getMOPLockKey((Long)this.modelId, (Long)orgId, (Long)this.periodId));
        }
        return lockKeyMap;
    }

    public void unlock() {
        for (DLock lock : this.dLockMap.values()) {
            if (lock == null) continue;
            try {
                lock.unlock();
            }
            catch (Exception e) {
                logger.error("DLock unlock error", (Throwable)e);
            }
        }
    }
}

