/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.model;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.engine.helper.PAAllocationHelper;
import kd.fi.pa.engine.model.AbstractRule;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PARuleHelper;

public class AllocationRule
extends AbstractRule {
    private static final long serialVersionUID = 4988887102471839926L;
    private Long id;
    private String number;
    private String name;
    private DynamicObject analysisModel;
    private DynamicObjectCollection measureEntry;
    private DynamicObjectCollection senderEntry;
    private BigDecimal sendRate;
    private String shareType;
    private String tailDifferenceType;
    private String accountFilter;
    private String limitType;
    private DynamicObject measure;
    private DynamicObject shareFactor;
    private MultiOrgShareEnum multiOrgShare;
    private Set<String> relatedGroupDimNums;
    private boolean addShareFlag;
    private DynamicObjectCollection relatedGroupDim;
    private DynamicObjectCollection receiverEntry;
    private DynamicObjectCollection receiverDetailEntry;
    private DynamicObjectCollection receiverLimitEntry;
    private DynamicObjectCollection flagEntry;

    @Override
    public AllocationRule createModel(Long id) {
        AllocationRule rule = new AllocationRule();
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_sharerulenew");
        long analysisModelId = allocationRuleDy.getLong("analysismodel_id");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        rule.setId(id);
        rule.setNumber(allocationRuleDy.getString("number"));
        rule.setName(allocationRuleDy.getString("name"));
        rule.setAnalysisModel(analysisModelDy);
        rule.setMeasureEntry(allocationRuleDy.getDynamicObjectCollection("mulbasedatafield"));
        rule.setSenderEntry(allocationRuleDy.getDynamicObjectCollection("sendentryentity"));
        rule.setSendRate(allocationRuleDy.getBigDecimal("sendrate"));
        rule.setShareType(allocationRuleDy.getString("receiverule"));
        rule.setTailDifferenceType(allocationRuleDy.getString("taildifferencetype"));
        rule.setLimitType(allocationRuleDy.getString("limittype"));
        rule.setAccountFilter(allocationRuleDy.getString("accountfilter_tag"));
        rule.setMeasure(allocationRuleDy.getDynamicObject("measure"));
        rule.setShareFactor(allocationRuleDy.getDynamicObject("sharefactor"));
        rule.setRelatedGroupDim(allocationRuleDy.getDynamicObjectCollection("relatedgroupdim"));
        rule.setAddShareFlag(allocationRuleDy.getBoolean("addshareflag"));
        rule.setReceiverEntry(allocationRuleDy.getDynamicObjectCollection("receiveentryentity"));
        rule.setReceiverDetailEntry(allocationRuleDy.getDynamicObjectCollection("savesubflexdata"));
        rule.setReceiverLimitEntry(allocationRuleDy.getDynamicObjectCollection("savesublimit"));
        rule.setFlagEntry(allocationRuleDy.getDynamicObjectCollection("flagentryentity"));
        MultiOrgShareEnum multiOrgShareEnum = MultiOrgShareEnum.getEnum((String)allocationRuleDy.getString("multiorgshare"));
        if (multiOrgShareEnum == null) {
            String orgDimNum = PAAnalysisModelHelper.getOrgDimNum((DynamicObject)analysisModelDy);
            rule.setMultiOrgShare(PARuleHelper.computeAllocationMultiOrgShare((Long)id, (String)orgDimNum));
        } else {
            rule.setMultiOrgShare(multiOrgShareEnum);
        }
        Set<String> groupDimSet = this.processRelatedGroupDims(rule.getShareType(), rule.getRelatedGroupDim(), rule.getMultiOrgShare(), analysisModelDy);
        rule.setRelatedGroupDimNums(groupDimSet);
        return rule;
    }

    private Set<String> processRelatedGroupDims(String shareType, DynamicObjectCollection relatedGroupDim, MultiOrgShareEnum multiOrgShare, DynamicObject analysisModel) {
        LinkedHashSet<String> groupDimNums = new LinkedHashSet<String>(PAAllocationHelper.parseRelatedGroupDimNums(relatedGroupDim));
        if (ShareTypeEnum.SHARE_SUBJECT.getType().equals(shareType) && MultiOrgShareEnum.NO == multiOrgShare) {
            String orgDimNum = PAAnalysisModelHelper.getOrgDimNum((DynamicObject)analysisModel);
            if (StringUtils.isEmpty((CharSequence)orgDimNum)) {
                throw new KDBizException("orgDim is null");
            }
            groupDimNums.add(orgDimNum);
        }
        return groupDimNums;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DynamicObject getAnalysisModel() {
        return this.analysisModel;
    }

    public void setAnalysisModel(DynamicObject analysisModel) {
        this.analysisModel = analysisModel;
    }

    public DynamicObjectCollection getSenderEntry() {
        return this.senderEntry;
    }

    public DynamicObjectCollection getMeasureEntry() {
        return this.measureEntry;
    }

    public void setMeasureEntry(DynamicObjectCollection measureEntry) {
        this.measureEntry = measureEntry;
    }

    public void setSenderEntry(DynamicObjectCollection senderEntry) {
        this.senderEntry = senderEntry;
    }

    public BigDecimal getSendRate() {
        return this.sendRate;
    }

    public void setSendRate(BigDecimal sendRate) {
        this.sendRate = sendRate;
    }

    public String getShareType() {
        return this.shareType;
    }

    public void setShareType(String shareType) {
        this.shareType = shareType;
    }

    public String getTailDifferenceType() {
        return this.tailDifferenceType;
    }

    public void setTailDifferenceType(String tailDifferenceType) {
        this.tailDifferenceType = tailDifferenceType;
    }

    public String getAccountFilter() {
        return this.accountFilter;
    }

    public void setAccountFilter(String accountFilter) {
        this.accountFilter = accountFilter;
    }

    public String getLimitType() {
        return this.limitType;
    }

    public void setLimitType(String limitType) {
        this.limitType = limitType;
    }

    public DynamicObject getMeasure() {
        return this.measure;
    }

    public void setMeasure(DynamicObject measure) {
        this.measure = measure;
    }

    public DynamicObject getShareFactor() {
        return this.shareFactor;
    }

    public void setShareFactor(DynamicObject shareFactor) {
        this.shareFactor = shareFactor;
    }

    public DynamicObjectCollection getRelatedGroupDim() {
        return this.relatedGroupDim;
    }

    public void setRelatedGroupDim(DynamicObjectCollection relatedGroupDim) {
        this.relatedGroupDim = relatedGroupDim;
    }

    public MultiOrgShareEnum getMultiOrgShare() {
        return this.multiOrgShare;
    }

    public void setMultiOrgShare(MultiOrgShareEnum multiOrgShare) {
        this.multiOrgShare = multiOrgShare;
    }

    public Set<String> getRelatedGroupDimNums() {
        return this.relatedGroupDimNums;
    }

    public void setRelatedGroupDimNums(Set<String> relatedGroupDimNums) {
        this.relatedGroupDimNums = relatedGroupDimNums;
    }

    public boolean isAddShareFlag() {
        return this.addShareFlag;
    }

    public void setAddShareFlag(boolean addShareFlag) {
        this.addShareFlag = addShareFlag;
    }

    public DynamicObjectCollection getReceiverEntry() {
        return this.receiverEntry;
    }

    public void setReceiverEntry(DynamicObjectCollection receiverEntry) {
        this.receiverEntry = receiverEntry;
    }

    public DynamicObjectCollection getReceiverDetailEntry() {
        return this.receiverDetailEntry;
    }

    public void setReceiverDetailEntry(DynamicObjectCollection receiverDetailEntry) {
        this.receiverDetailEntry = receiverDetailEntry;
    }

    public DynamicObjectCollection getReceiverLimitEntry() {
        return this.receiverLimitEntry;
    }

    public void setReceiverLimitEntry(DynamicObjectCollection receiverLimitEntry) {
        this.receiverLimitEntry = receiverLimitEntry;
    }

    public DynamicObjectCollection getFlagEntry() {
        return this.flagEntry;
    }

    public void setFlagEntry(DynamicObjectCollection flagEntry) {
        this.flagEntry = flagEntry;
    }
}

