/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.model.AbstractRule;
import kd.fi.pa.enginealgox.utils.FieldUtil;

public class DerivationRule
extends AbstractRule {
    private static final long serialVersionUID = -7234412850024294462L;
    private Long id;
    private String number;
    private String name;
    private DynamicObject analysisModel;
    private String derivationMode;
    private String mappingMap;
    private String mappingMapType;
    private String entrySeqField;
    private DynamicObjectCollection mtSourceEntryEntity;
    private DynamicObjectCollection mtTargetEntryEntity;
    private DynamicObject mappingRelationShip;
    private DynamicObjectCollection sourceEntryEntity;
    private DynamicObjectCollection targetEntryEntity;
    private DynamicObjectCollection customEntryEntity;
    private DynamicObjectCollection sendEntryEntity;

    @Override
    public DerivationRule createModel(Long id) {
        DerivationRule rule = new DerivationRule();
        DynamicObject derivationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"pa_derivationrule");
        long analysisModelId = derivationRuleDy.getLong("analysismodel_id");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        rule.setId(id);
        rule.setNumber(derivationRuleDy.getString("number"));
        rule.setName(derivationRuleDy.getString("name"));
        rule.setAnalysisModel(analysisModelDy);
        rule.setDerivationMode(derivationRuleDy.getString("derivationmode"));
        rule.setSendEntryEntity(derivationRuleDy.getDynamicObjectCollection("sendentryentity"));
        rule.setMappingMap(derivationRuleDy.getString("mappingmap"));
        rule.setMappingMapType(derivationRuleDy.getString("mappingmaptype"));
        rule.setMappingRelationShip(derivationRuleDy.getDynamicObject("mappingrelationship"));
        rule.setSourceEntryEntity(derivationRuleDy.getDynamicObjectCollection("source_entryentity"));
        rule.setTargetEntryEntity(derivationRuleDy.getDynamicObjectCollection("target_entryentity"));
        rule.setMtSourceEntryEntity(derivationRuleDy.getDynamicObjectCollection("mt_source_entryentity"));
        rule.setMtTargetEntryEntity(derivationRuleDy.getDynamicObjectCollection("mt_target_entryentity"));
        rule.setCustomEntryEntity(derivationRuleDy.getDynamicObjectCollection("custom_entryentity"));
        rule.genEntrySeqFromTargetField();
        return rule;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DynamicObject getAnalysisModel() {
        return this.analysisModel;
    }

    public void setAnalysisModel(DynamicObject analysisModel) {
        this.analysisModel = analysisModel;
    }

    public String getDerivationMode() {
        return this.derivationMode;
    }

    public void setDerivationMode(String derivationMode) {
        this.derivationMode = derivationMode;
    }

    public DynamicObjectCollection getSendEntryEntity() {
        return this.sendEntryEntity;
    }

    public void setSendEntryEntity(DynamicObjectCollection sendEntryEntity) {
        this.sendEntryEntity = sendEntryEntity;
    }

    public String getMappingMap() {
        return this.mappingMap;
    }

    public void setMappingMap(String mappingMap) {
        this.mappingMap = mappingMap;
    }

    public String getMappingMapType() {
        return this.mappingMapType;
    }

    public void setMappingMapType(String mappingMapType) {
        this.mappingMapType = mappingMapType;
    }

    public DynamicObject getMappingRelationShip() {
        return this.mappingRelationShip;
    }

    public void setMappingRelationShip(DynamicObject mappingRelationShip) {
        this.mappingRelationShip = mappingRelationShip;
    }

    public DynamicObjectCollection getMtSourceEntryEntity() {
        return this.mtSourceEntryEntity;
    }

    public void setMtSourceEntryEntity(DynamicObjectCollection mtSourceEntryEntity) {
        this.mtSourceEntryEntity = mtSourceEntryEntity;
    }

    public DynamicObjectCollection getMtTargetEntryEntity() {
        return this.mtTargetEntryEntity;
    }

    public void setMtTargetEntryEntity(DynamicObjectCollection mtTargetEntryEntity) {
        this.mtTargetEntryEntity = mtTargetEntryEntity;
    }

    public DynamicObjectCollection getSourceEntryEntity() {
        return this.sourceEntryEntity;
    }

    public void setSourceEntryEntity(DynamicObjectCollection sourceEntryEntity) {
        this.sourceEntryEntity = sourceEntryEntity;
    }

    public DynamicObjectCollection getTargetEntryEntity() {
        return this.targetEntryEntity;
    }

    public void setTargetEntryEntity(DynamicObjectCollection targetEntryEntity) {
        this.targetEntryEntity = targetEntryEntity;
    }

    public DynamicObjectCollection getCustomEntryEntity() {
        return this.customEntryEntity;
    }

    public void setCustomEntryEntity(DynamicObjectCollection customEntryEntity) {
        this.customEntryEntity = customEntryEntity;
    }

    public String getEntrySeqField() {
        return this.entrySeqField;
    }

    public void setEntrySeqField(String entrySeqField) {
        this.entrySeqField = entrySeqField;
    }

    public void genEntrySeqFromTargetField() {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(3);
        if (this.mtTargetEntryEntity == null) {
            return;
        }
        if (!DerivationTypeEnum.DERIVATION_MAPPING_TABLE.getType().equals(this.getDerivationMode())) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getMappingMapType());
        Map entryMap = mainEntityType.getAllEntities();
        entryMap.remove(this.getMappingMapType());
        List entryKeySet = entryMap.keySet().stream().map(entryKey -> entryKey + '.').collect(Collectors.toList());
        if (!entryKeySet.isEmpty()) {
            for (DynamicObject dy : this.mtTargetEntryEntity) {
                String mTargetField = dy.getString("mt_m_targetfield_number");
                for (String entryKey2 : entryKeySet) {
                    if (!mTargetField.startsWith(entryKey2)) continue;
                    String seq = entryKey2 + "seq";
                    String seqFieldFormat = FieldUtil.otherFormatAlias(seq);
                    fieldSet.add(seqFieldFormat);
                }
            }
        }
        if (fieldSet.size() > 1) {
            throw new PABusinessException(PABusinessErrorCodeBox.BUSINESS, ResManager.loadKDString((String)"\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6-\u57fa\u7840\u8d44\u6599\u5b57\u6bb5,\u4e0d\u652f\u6301\u591a\u5206\u5f55\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539", (String)"DerivationRule_0", (String)"fi-pa-business", (Object[])new Object[0]));
        }
        if (fieldSet.isEmpty()) {
            return;
        }
        this.entrySeqField = (String)fieldSet.iterator().next();
    }
}

