/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.service;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.pa.engine.service.IEngineService;

public class EngineServiceFactory {
    private static final ConcurrentHashMap<String, IEngineService> engineServiceMap = new ConcurrentHashMap();
    private static String centerId = null;

    private EngineServiceFactory() {
    }

    public static IEngineService getExecuteEngineService() {
        return EngineServiceFactory.getEngineServiceByClassName("kd.fi.pa.engine.service.ExecuteEngineService");
    }

    public static IEngineService getTaskExecuteEngineService() {
        return EngineServiceFactory.getEngineServiceByClassName("kd.fi.pa.engine.service.TaskExecuteEngineService");
    }

    public static IEngineService getChangeEngineService() {
        return EngineServiceFactory.getEngineServiceByClassName("kd.fi.pa.engine.service.ChangeEngineService");
    }

    public static IEngineService getParseEngineService() {
        return EngineServiceFactory.getEngineServiceByClassName("kd.fi.pa.engine.service.ParseEngineService");
    }

    private static IEngineService getEngineServiceByClassName(String className) {
        centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        IEngineService iEngineService = engineServiceMap.get(centerId + className);
        if (iEngineService != null) {
            return iEngineService;
        }
        try {
            Class<?> clazz = Class.forName(className);
            IEngineService instance = (IEngineService)clazz.newInstance();
            engineServiceMap.put(centerId + className, instance);
            return instance;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("fi.pa.engine.service.EngineServiceFactory", "get engine service error"), new Object[0]);
        }
    }
}

