/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.service;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.executor.PaExecutor;
import kd.fi.pa.engine.lock.ModelTaskLock;
import kd.fi.pa.engine.service.AbstractEngineService;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PALogHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class ExecuteEngineService
extends AbstractEngineService {
    private static final Log logger = LogFactory.getLog(ExecuteEngineService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work(ExecutionLogDTO executionLogDTO) {
        block9: {
            logger.info("[FI-PA] ExecuteEngineService work begin");
            List<ExecutionLogDTO> executionLogDTOList = Collections.singletonList(executionLogDTO);
            PALogHelper.genExecutionLogId(executionLogDTOList);
            Object[] executionLogArr = PALogHelper.createExecutionLog(executionLogDTOList);
            if (executionLogArr == null) {
                logger.error("[FI-PA] Create ExecutionLog failed");
                throw new KDBizException("Create ExecutionLog failed");
            }
            Long logId = executionLogDTO.getId();
            boolean needLock = executionLogDTO.getNeedLock() == null || executionLogDTO.getNeedLock() != false;
            ModelTaskLock taskLock = needLock ? this.createTaskLock(executionLogDTO) : null;
            String lockErrorMsg = "Get model task lock failed, please try later";
            if (taskLock != null && taskLock.existsLock()) {
                logger.error("[FI-PA] Get model task lock failed");
                PALogHelper.updateExecuteLogStatus((Object)logId, (String)PASyncLogStatusEnum.FAILURE.getCodeString(), (String)lockErrorMsg, (String)lockErrorMsg);
                throw new KDBizException(lockErrorMsg);
            }
            try {
                if (taskLock == null || taskLock.tryLock(5000L)) {
                    try {
                        PALogHelper.updateExecuteLogStatus((Object)logId, (String)PASyncLogStatusEnum.PROCESSING.getCodeString());
                        PaExecutor paExecutor = new PaExecutor();
                        paExecutor.execute(executionLogDTO);
                        PALogHelper.updateExecuteLogStatus((Object)logId, (String)PASyncLogStatusEnum.SUCCESS.getCodeString());
                        break block9;
                    }
                    catch (Exception ex) {
                        String remark = StringUtils.isNotEmpty((String)ex.getMessage()) ? ex.getMessage() : ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u5728monitor\u5e73\u53f0\u4e2d\u641c\u7d22\u201c[FI-PA] Execute error\u201d\u67e5\u770b\u539f\u56e0\u3002", (String)"ExecuteEngineService_0", (String)"fi-pa-business", (Object[])new Object[0]);
                        PALogHelper.updateExecuteLogStatus((Object)logId, (String)PASyncLogStatusEnum.FAILURE.getCodeString(), (String)remark, (String)remark);
                        logger.error("[FI-PA] Execute error!", (Throwable)ex);
                        throw new KDBizException(remark);
                    }
                }
                logger.error("[FI-PA] Get model task lock failed");
                PALogHelper.updateExecuteLogStatus((Object)logId, (String)PASyncLogStatusEnum.FAILURE.getCodeString(), (String)lockErrorMsg, (String)lockErrorMsg);
                throw new KDBizException(lockErrorMsg);
            }
            finally {
                if (taskLock != null) {
                    taskLock.unlock();
                }
            }
        }
        logger.info("[FI-PA] ExecuteEngineService work end");
    }

    private ModelTaskLock createTaskLock(ExecutionLogDTO logDTO) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)logDTO.getAnalysisModel());
        String detailEntityNum = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModel.getString("tablenumber"));
        return ModelTaskLock.create(detailEntityNum, logDTO.getAnalysisModel(), logDTO.getOrgIds(), logDTO.getStartPeriod());
    }
}

