/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.service;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.pa.engine.model.IRule;

public class RuleServiceFactory {
    private static final ConcurrentHashMap<String, IRule> ruleServiceMap = new ConcurrentHashMap();
    private static String centerId = null;

    private RuleServiceFactory() {
    }

    public static IRule getAllocationRule() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.AllocationRule");
    }

    public static IRule getDerivationRule() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.DerivationRule");
    }

    public static IRule getValidateRule() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.ValidateRule");
    }

    public static IRule getAdjustRule() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.AdjustRule");
    }

    public static IRule getWriteOffRuleOnce() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.OnceWriteOffRule");
    }

    public static IRule getBatchWriteOffRule() {
        return RuleServiceFactory.getIRuleServiceByClassName("kd.fi.pa.engine.model.BatchWriteOffRule");
    }

    private static IRule getIRuleServiceByClassName(String className) {
        centerId = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId()).getAccountId();
        IRule iRule = ruleServiceMap.get(centerId + className);
        if (iRule != null) {
            return iRule;
        }
        try {
            Class<?> clazz = Class.forName(className);
            IRule instance = (IRule)clazz.newInstance();
            ruleServiceMap.put(centerId + className, instance);
            return instance;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("fi.pa.engine.service.RuleServiceFactory", "get rule service error"), new Object[0]);
        }
    }
}

