/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.AdExecutionLogDTO;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.dto.ExecutionLogEntryDTO;
import kd.fi.pa.dto.RuleExecutionLogDTO;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.lock.ModelTaskLock;
import kd.fi.pa.engine.model.TaskInst;
import kd.fi.pa.engine.mservice.TaskInstMService;
import kd.fi.pa.engine.service.AbstractEngineService;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataAbstractWorkTask;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.engine.task.IDataWorkTaskManager;
import kd.fi.pa.engine.task.PABusinessManageSequenceTaskGroup;
import kd.fi.pa.engine.task.PABusinessSequenceTaskGroup;
import kd.fi.pa.engine.task.PABusinessSimpleAdjustTask;
import kd.fi.pa.engine.task.PABusinessSimpleOffTask;
import kd.fi.pa.engine.task.PABusinessSimpleRuleTask;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.SubTaskInstStatusEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PALogHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class TaskExecuteEngineService
extends AbstractEngineService {
    private static final Log logger = LogFactory.getLog(TaskExecuteEngineService.class);

    public boolean check(Collection<ExecutionLogDTO> executionLogDTOList, TaskInst taskInst) {
        if (executionLogDTOList.isEmpty()) {
            logger.error("[FI-PA] TaskExecuteEngineService executionLogDTOList is empty");
            return false;
        }
        if (taskInst == null) {
            logger.error("[FI-PA] TaskExecuteEngineService taskInst is null");
            return false;
        }
        return true;
    }

    public boolean check(ExecutionLogDTO executionLogDTO, TaskInst taskInst) {
        if (executionLogDTO == null) {
            logger.error("[FI-PA] TaskExecuteEngineService executionLogDTO is null");
            return false;
        }
        if (taskInst == null) {
            logger.error("[FI-PA] TaskExecuteEngineService taskInst is null");
            return false;
        }
        return true;
    }

    public String work(Collection<ExecutionLogDTO> executionLogDTOList, TaskInst taskInst) {
        if (!this.check(executionLogDTOList, taskInst)) {
            logger.error("[FI-PA] TaskExecuteEngineService task check failed");
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "check error");
        }
        PALogHelper.genExecutionLogId(executionLogDTOList);
        Object[] executionLogArr = PALogHelper.createExecutionLog(executionLogDTOList);
        if (executionLogArr == null) {
            logger.error("[FI-PA] TaskExecute ExecutionLogArr empty error");
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "executionLogArr empty error");
        }
        try {
            this.createTaskInst(executionLogDTOList, taskInst);
        }
        catch (Exception e) {
            logger.error("[FI-PA] TaskExecute createTaskInst error", (Throwable)e);
        }
        PABusinessManageSequenceTaskGroup businessManageTask = this.createBusinessManageTask();
        for (ExecutionLogDTO executionLogDTO : executionLogDTOList) {
            PABusinessSequenceTaskGroup businessTask = this.createBusinessTask(executionLogDTO);
            businessManageTask.addSubTask((Callable)((Object)businessTask));
        }
        IDataWorkTaskManager dataWorkTaskManager = IDataWorkTaskManager.getInstance();
        dataWorkTaskManager.submit((IDataWorkTask)businessManageTask);
        return businessManageTask.getTaskKey().toString();
    }

    public String work(ExecutionLogDTO executionLogDTO, TaskInst taskInst) {
        block5: {
            if (!this.check(executionLogDTO, taskInst)) {
                logger.error("[FI-PA] TaskExecuteEngineService task check failed");
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "check error");
            }
            List<ExecutionLogDTO> executionLogDTOList = Collections.singletonList(executionLogDTO);
            PALogHelper.genExecutionLogId(executionLogDTOList);
            Object[] executionLogArr = PALogHelper.createExecutionLog(executionLogDTOList);
            if (executionLogArr == null) {
                if (logger.isErrorEnabled()) {
                    logger.error("[FI-PA] TaskExecute ExecutionLogArr empty error");
                }
                throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "executionLogArr empty error");
            }
            try {
                this.createTaskInst(executionLogDTOList, taskInst);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("[FI-PA] TaskExecute createTaskInst error", (Throwable)e);
            }
        }
        PABusinessSequenceTaskGroup businessTask = this.createBusinessTask(executionLogDTO);
        IDataWorkTaskManager dataWorkTaskManager = IDataWorkTaskManager.getInstance();
        dataWorkTaskManager.submit((IDataWorkTask)businessTask);
        return businessTask.getTaskKey().toString();
    }

    private void createTaskInst(Collection<ExecutionLogDTO> executionLogDTOList, TaskInst taskInst) {
        for (ExecutionLogDTO executionLogDTO : executionLogDTOList) {
            boolean registered = taskInst.isRegistered();
            Long requestId = taskInst.getRequestId();
            List entryDTOList = executionLogDTO.getEntry();
            executionLogDTO.setTaskInstRequestId(requestId);
            executionLogDTO.setTaskInstRegistered(registered);
            if (!registered) continue;
            int count = entryDTOList.size();
            for (ExecutionLogEntryDTO entryDto : entryDTOList) {
                boolean isSummary = entryDto.isSummary();
                if (!isSummary) continue;
                ++count;
            }
            executionLogDTO.setTaskCount(count);
            int index = 0;
            ArrayList<Map<String, Object>> subTaskInfoList = new ArrayList<Map<String, Object>>(16);
            for (ExecutionLogEntryDTO executionLogEntryDTO : entryDTOList) {
                ++index;
                String ruleType = executionLogEntryDTO.getRuleType();
                String stepName = executionLogEntryDTO.getStepName();
                String ruleTaskUUID = UUID.randomUUID().toString();
                String rueTypeName = ruleType.equals("A") ? ResManager.loadKDString((String)"\u63a8\u5bfc", (String)"TaskExecuteEngineService_0", (String)"fi-pa-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u644a", (String)"TaskExecuteEngineService_1", (String)"fi-pa-business", (Object[])new Object[0]);
                String ruleTaskName = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406-%1$s-%2$s", (String)"TaskExecuteEngineService_2", (String)"fi-pa-business", (Object[])new Object[0]), rueTypeName, stepName);
                executionLogEntryDTO.setRuleTaskIndex(index);
                executionLogEntryDTO.setRuleTaskUUID(ruleTaskUUID);
                executionLogEntryDTO.setRuleTaskName(ruleTaskName);
                HashMap<String, Object> ruleSubTaskInfoMap = new HashMap<String, Object>(16);
                ruleSubTaskInfoMap.put("subTaskIndex", index);
                ruleSubTaskInfoMap.put("subTaskName", ruleTaskName);
                ruleSubTaskInfoMap.put("subTaskStatus", SubTaskInstStatusEnum.PREPARE.getCodeString());
                ruleSubTaskInfoMap.put("uuid", ruleTaskUUID);
                subTaskInfoList.add(ruleSubTaskInfoMap);
                boolean isSummary = executionLogEntryDTO.isSummary();
                if (!isSummary) continue;
                String sumCalTaskUUID = UUID.randomUUID().toString();
                String sumCalTaskName = ResManager.loadKDString((String)"\u6c47\u603b\u8ba1\u7b97", (String)"TaskExecuteEngineService_3", (String)"fi-pa-business", (Object[])new Object[0]);
                executionLogEntryDTO.setSumCalTaskIndex(++index);
                executionLogEntryDTO.setSumCalTaskUUID(sumCalTaskUUID);
                executionLogEntryDTO.setSumCalTaskName(sumCalTaskName);
                HashMap<String, Object> sumSubTaskInfoMap = new HashMap<String, Object>(16);
                sumSubTaskInfoMap.put("subTaskIndex", index);
                sumSubTaskInfoMap.put("subTaskName", sumCalTaskName);
                sumSubTaskInfoMap.put("subTaskStatus", SubTaskInstStatusEnum.PREPARE.getCodeString());
                sumSubTaskInfoMap.put("uuid", sumCalTaskUUID);
                subTaskInfoList.add(sumSubTaskInfoMap);
            }
            TaskInstMService.batchRegisterSubTask(requestId, count, subTaskInfoList);
        }
    }

    private PABusinessManageSequenceTaskGroup createBusinessManageTask() {
        String taskKey = "Manage_" + System.currentTimeMillis();
        return new PABusinessManageSequenceTaskGroup((Serializable)((Object)taskKey), null);
    }

    private PABusinessSequenceTaskGroup createBusinessTask(ExecutionLogDTO executionLogDTO) {
        String taskKey = "Business_" + System.currentTimeMillis();
        boolean needLock = executionLogDTO.getNeedLock() == null || executionLogDTO.getNeedLock() != false;
        ModelTaskLock taskLock = needLock ? this.createTaskLock(executionLogDTO) : null;
        PABusinessSequenceTaskGroup groupTask = new PABusinessSequenceTaskGroup((Serializable)((Object)taskKey), null, taskLock, executionLogDTO);
        List<IDataAbstractWorkTask<BusinessTaskResult>> paSimpleRuleWorkTasks = this.batchCreateSimpleTask(executionLogDTO);
        for (IDataAbstractWorkTask<BusinessTaskResult> simpleTask : paSimpleRuleWorkTasks) {
            groupTask.addSubTask((Callable)simpleTask);
        }
        return groupTask;
    }

    private List<IDataAbstractWorkTask<BusinessTaskResult>> batchCreateSimpleTask(ExecutionLogDTO executionLogDTO) {
        ExecutionModeEnum executionMode = executionLogDTO.getExecutionMode();
        switch (executionMode) {
            case execute: {
                return this.batchCreateSimpleRuleTask(executionLogDTO);
            }
            case adjust: {
                return this.batchCreateSimpleAdjustTask(executionLogDTO);
            }
            case writeOff: {
                return this.batchCreateSimpleOffTask(executionLogDTO);
            }
        }
        return new ArrayList<IDataAbstractWorkTask<BusinessTaskResult>>();
    }

    private List<IDataAbstractWorkTask<BusinessTaskResult>> batchCreateSimpleRuleTask(ExecutionLogDTO executionLogDTO) {
        Long executeLogId = executionLogDTO.getId();
        List executionLogDTOEntry = executionLogDTO.getEntry();
        int taskCount = executionLogDTO.getTaskCount();
        boolean taskInstRegistered = executionLogDTO.isTaskInstRegistered();
        ArrayList<RuleExecutionLogDTO> executionRuleLogList = new ArrayList<RuleExecutionLogDTO>(executionLogDTOEntry.size());
        for (ExecutionLogEntryDTO entryDto : executionLogDTOEntry) {
            String stepName = entryDto.getStepName();
            String ruleType = entryDto.getRuleType();
            Long ruleId = entryDto.getRuleId();
            Long businessRuleId = entryDto.getBelongBusinessRuleId();
            boolean isSummary = entryDto.isSummary();
            BigDecimal sendRate = entryDto.getSendRate();
            Date executeTime = new Date();
            Long detailTime = System.currentTimeMillis();
            int ruleTaskIndex = entryDto.getRuleTaskIndex();
            String ruleTaskUUID = entryDto.getRuleTaskUUID();
            String ruleTaskName = entryDto.getRuleTaskName();
            int sumCalTaskIndex = entryDto.getSumCalTaskIndex();
            String sumCalTaskUUID = entryDto.getSumCalTaskUUID();
            String sumCalTaskName = entryDto.getSumCalTaskName();
            RuleExecutionLogDTO ruleExecutionLogDTO = new RuleExecutionLogDTO(executeLogId, stepName, ruleType, ruleId, businessRuleId, isSummary, PASyncLogStatusEnum.NEW, executeTime, detailTime, sendRate, ruleTaskIndex, sumCalTaskIndex, ruleTaskUUID, ruleTaskName, sumCalTaskUUID, sumCalTaskName);
            executionRuleLogList.add(ruleExecutionLogDTO);
        }
        PALogHelper.genExecutionRuleLogId(executionRuleLogList);
        Object[] executionRuleLogArr = PALogHelper.createRuleExecutionLog(executionRuleLogList);
        if (executionRuleLogArr == null) {
            if (logger.isErrorEnabled()) {
                logger.error("[FI-PA] TaskExecute ExecutionRuleLogArr empty error");
            }
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "executionRuleLogArr empty error");
        }
        Map accountMap = executionLogDTO.getAccountMap();
        ArrayList<IDataAbstractWorkTask<BusinessTaskResult>> taskList = new ArrayList<IDataAbstractWorkTask<BusinessTaskResult>>(executionRuleLogList.size());
        for (RuleExecutionLogDTO ruleExecutionLogDTO : executionRuleLogList) {
            String taskKey = "Rule_" + System.currentTimeMillis();
            Long executionRuleLogId = ruleExecutionLogDTO.getId();
            Long ruleId = ruleExecutionLogDTO.getRuleId();
            String ruleType = ruleExecutionLogDTO.getRuleType();
            Long businessRuleId = ruleExecutionLogDTO.getBusinessRuleId();
            Set accountIds = (Set)accountMap.get(businessRuleId);
            boolean isSummary = ruleExecutionLogDTO.isSummary();
            int ruleTaskIndex = ruleExecutionLogDTO.getRuleTaskIndex();
            String ruleTaskUUID = ruleExecutionLogDTO.getRuleTaskUUID();
            String ruleTaskName = ruleExecutionLogDTO.getRuleTaskName();
            int sumCalTaskIndex = ruleExecutionLogDTO.getSumCalTaskIndex();
            String sumCalTaskUUID = ruleExecutionLogDTO.getSumCalTaskUUID();
            String sumCalTaskName = ruleExecutionLogDTO.getSumCalTaskName();
            PABusinessSimpleRuleTask simpleTask = new PABusinessSimpleRuleTask((Serializable)((Object)taskKey), executeLogId, executionRuleLogId, ruleId, ruleType, businessRuleId, accountIds, isSummary, taskInstRegistered, taskCount, ruleTaskIndex, sumCalTaskIndex, executionLogDTO.getTaskInstRequestId(), ruleTaskUUID, ruleTaskName, sumCalTaskUUID, sumCalTaskName);
            taskList.add(simpleTask);
        }
        return taskList;
    }

    private List<IDataAbstractWorkTask<BusinessTaskResult>> batchCreateSimpleAdjustTask(ExecutionLogDTO executionLogDTO) {
        Long executeLogId = executionLogDTO.getId();
        List businessIdList = executionLogDTO.getBusinessIdList();
        ArrayList<AdExecutionLogDTO> executionAdjustLogList = new ArrayList<AdExecutionLogDTO>(businessIdList.size());
        for (Long businessId : businessIdList) {
            AdExecutionLogDTO adExecutionLogDTO = new AdExecutionLogDTO(executeLogId, businessId, PASyncLogStatusEnum.NEW, new Date(), null, null);
            adExecutionLogDTO.setDetailTime(Long.valueOf(System.currentTimeMillis()));
            executionAdjustLogList.add(adExecutionLogDTO);
        }
        PALogHelper.genExecutionAdjustLogId(executionAdjustLogList);
        Object[] executionAdjustLogArr = PALogHelper.createAdjustExecutionLog(executionAdjustLogList);
        if (executionAdjustLogArr == null) {
            if (logger.isErrorEnabled()) {
                logger.error("[FI-PA] TaskExecute ExecutionAdjustLogArr empty error");
            }
            throw new PABusinessException(PABusinessErrorCodeBox.SYSTEM, "executionAdjustLogArr empty error");
        }
        ArrayList<IDataAbstractWorkTask<BusinessTaskResult>> taskList = new ArrayList<IDataAbstractWorkTask<BusinessTaskResult>>(executionAdjustLogList.size());
        for (AdExecutionLogDTO executionAdjustLog : executionAdjustLogList) {
            String taskKey = "Adjust_" + System.currentTimeMillis();
            Long adjustLogId = executionAdjustLog.getId();
            Long adjustPk = executionAdjustLog.getAdjustPk();
            PABusinessSimpleAdjustTask simpleTask = new PABusinessSimpleAdjustTask(taskKey, adjustLogId, adjustPk, executeLogId);
            taskList.add(simpleTask);
        }
        return taskList;
    }

    private List<IDataAbstractWorkTask<BusinessTaskResult>> batchCreateSimpleOffTask(ExecutionLogDTO executionLogDTO) {
        String taskKey = "Off_" + System.currentTimeMillis();
        PABusinessSimpleOffTask simpleTask = new PABusinessSimpleOffTask(taskKey, executionLogDTO);
        return Collections.singletonList(simpleTask);
    }

    private ModelTaskLock createTaskLock(ExecutionLogDTO logDTO) {
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)logDTO.getAnalysisModel());
        String detailEntityNum = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModel.getString("tablenumber"));
        ModelTaskLock modelTaskLock = null;
        modelTaskLock = logDTO.isIncludeMultiOrgShare() ? ModelTaskLock.create(detailEntityNum, logDTO.getAnalysisModel()) : ModelTaskLock.create(detailEntityNum, logDTO.getAnalysisModel(), logDTO.getOrgIds(), logDTO.getStartPeriod());
        return modelTaskLock;
    }
}

