/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.io.Serializable;
import kd.fi.pa.common.event.IWorkTaskStatusEvent;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataSequenceWorkTaskGroup;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.engine.task.IWorkTaskResultProcessor;
import kd.fi.pa.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.fi.pa.engine.task.status.IDataWorkTaskStatusMgr;
import kd.fi.pa.engine.task.status.PAWorkTaskStatusConsumer;

public class AbstractBusinessSequenceTaskGroup
extends IDataSequenceWorkTaskGroup<BusinessTaskResult, IDataWorkTask<BusinessTaskResult>, IDataSimpleWorkTaskStatisticStatus> {
    public AbstractBusinessSequenceTaskGroup(Serializable taskKey, Serializable version, IWorkTaskResultProcessor<IDataWorkTask<BusinessTaskResult>> processTaskResultFunc) {
        super(taskKey, version, processTaskResultFunc);
    }

    protected IDataWorkTaskStatusMgr getWorkTaskStatusMgr() {
        return PAWorkTaskStatusConsumer.getInstance();
    }

    protected void initTaskStatistics() {
        try {
            this.workTaskStatusEvent = new IDataSimpleWorkTaskStatisticStatus(this.taskKey, this.version, this.waitingTaskQueue.size());
            this.getWorkTaskStatusMgr().updateTaskStatus(this.workTaskStatusEvent);
        }
        catch (Exception e) {
            throw new PABusinessException(e, PABusinessErrorCodeBox.SYSTEM, "initTaskStatistics error");
        }
    }

    protected void updateTaskStatistics(int fetchDataCnt, int processDataCnt, int skipErrorDataCnt, int errorDataCnt) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.updateTaskStatistics(fetchDataCnt, processDataCnt, skipErrorDataCnt, errorDataCnt, this.totalStatisticsPoints);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatusEvent);
        }
        catch (Exception e) {
            throw new PABusinessException(e, PABusinessErrorCodeBox.SYSTEM, "updateTaskStatistics error");
        }
    }

    protected void endTaskStatistics(String message) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.setStatusMessage(message);
        workTaskStatusEvent.updateTaskEndStatus(true);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatusEvent);
        }
        catch (Exception e) {
            throw new PABusinessException(e, PABusinessErrorCodeBox.SYSTEM, "endTaskStatistics error");
        }
    }

    protected void errorTaskStatistics(String errorMessage) {
        IDataSimpleWorkTaskStatisticStatus workTaskStatusEvent = ((IDataSimpleWorkTaskStatisticStatus)this.getWorkTaskStatusEvent()).copy();
        workTaskStatusEvent.errorUpdateStatus(errorMessage);
        try {
            this.getWorkTaskStatusMgr().updateTaskStatus((IWorkTaskStatusEvent)workTaskStatusEvent);
        }
        catch (Exception e) {
            throw new PABusinessException(e, PABusinessErrorCodeBox.SYSTEM, "errorTaskStatistics error");
        }
    }
}

