/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.engine.bussinesslog.ExecutorLog;
import kd.fi.pa.engine.exception.PABusinessErrorCodeBox;
import kd.fi.pa.engine.exception.PABusinessException;

public class BusinessTaskResult
implements Serializable {
    private static final long serialVersionUID = -6309236821968980890L;
    public static final long FAIL_CODE = 0L;
    public static final long SUCCESS_CODE = 1L;
    public static final long SUCCESS_TIPS_CODE = 2L;
    private Long code;
    private String msg;
    private String msgCode;

    public BusinessTaskResult(Long code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public BusinessTaskResult(Long code, String msg, String msgCode) {
        this.code = code;
        this.msg = msg;
        this.msgCode = msgCode;
    }

    public static String getErrorMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u5728monitor\u5e73\u53f0\u4e2d\u641c\u7d22\u201c[FI-PA] TaskExecute Error\u201d\u67e5\u770b\u539f\u56e0", (String)"BusinessTaskResult_0", (String)"fi-pa-business", (Object[])new Object[0]);
    }

    public String getLogStatus() {
        if (this.code == 0L) {
            return PASyncLogStatusEnum.FAILURE.getCodeString();
        }
        return PASyncLogStatusEnum.SUCCESS.getCodeString();
    }

    public boolean getLogResultStatus() {
        return this.code != 0L;
    }

    public static BusinessTaskResult succeed() {
        return new BusinessTaskResult(1L, null);
    }

    public static BusinessTaskResult succeed(ExecutorLog executorLog) {
        String remarkInfo = executorLog.getRemarkInfo();
        String msg = executorLog.getLevitationMessage();
        String msgCode = executorLog.getLevitationCode();
        if (StringUtils.isBlank((CharSequence)msgCode)) {
            return new BusinessTaskResult(1L, remarkInfo);
        }
        return new BusinessTaskResult(2L, msg, msgCode);
    }

    public static BusinessTaskResult failed() {
        return new BusinessTaskResult(0L, BusinessTaskResult.getErrorMsg());
    }

    public static BusinessTaskResult failed(Throwable exception) {
        PABusinessException paBusinessException;
        if (exception instanceof PABusinessException && PABusinessErrorCodeBox.BUSINESS.match(paBusinessException = (PABusinessException)((Object)exception))) {
            return new BusinessTaskResult(0L, paBusinessException.getMessage());
        }
        return new BusinessTaskResult(0L, BusinessTaskResult.getErrorMsg());
    }

    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public String toString() {
        return "BusinessTaskResult{code=" + this.code + ", msg='" + this.msg + '\'' + ", msgCode='" + this.msgCode + '\'' + '}';
    }
}

