/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.engine.task.IWorkTaskResultProcessor;
import kd.fi.pa.enums.LevitationEnum;

public class BusinessTaskResultProcessor
implements IWorkTaskResultProcessor<IDataWorkTask<BusinessTaskResult>> {
    private final List<BusinessTaskResult> resultList = new LinkedList<BusinessTaskResult>();

    public Object processWorkTaskResult(int taskIndex, IDataWorkTask<BusinessTaskResult> task, Object taskResult) {
        if (taskResult != null) {
            this.resultList.add((BusinessTaskResult)taskResult);
        }
        return null;
    }

    public BusinessTaskResult getManageResult() {
        return new BusinessTaskResult(this.getManageResultCode(), this.getManageResultMsg());
    }

    private long getManageResultCode() {
        if (this.resultList.isEmpty()) {
            return 0L;
        }
        Set resultCodeSet = this.resultList.stream().map(BusinessTaskResult::getCode).collect(Collectors.toSet());
        if (resultCodeSet.contains(2L)) {
            return 2L;
        }
        return 1L;
    }

    private String getManageResultMsg() {
        return null;
    }

    public BusinessTaskResult getBasicResult() {
        return new BusinessTaskResult(this.getBasicResultCode(), this.getBasicResultMsg());
    }

    private long getBasicResultCode() {
        if (this.resultList.isEmpty()) {
            return 0L;
        }
        Set resultCodeSet = this.resultList.stream().map(BusinessTaskResult::getCode).collect(Collectors.toSet());
        if (resultCodeSet.contains(0L)) {
            return 0L;
        }
        if (resultCodeSet.contains(2L)) {
            return 2L;
        }
        return 1L;
    }

    private String getBasicResultMsg() {
        return this.getBasicResultMsg(this.getBasicResultCode());
    }

    private String getBasicResultMsg(long resultCode) {
        if (resultCode == 0L) {
            return this.resultList.stream().filter(v -> v.getCode() == 0L).findFirst().orElseGet(BusinessTaskResult::failed).getMsg();
        }
        if (resultCode == 2L) {
            Map<String, List<BusinessTaskResult>> resultGroupMap = this.resultList.stream().filter(v -> v.getCode() == 2L).collect(Collectors.groupingBy(BusinessTaskResult::getMsgCode));
            StringBuilder sbr = new StringBuilder();
            for (Map.Entry<String, List<BusinessTaskResult>> entry : resultGroupMap.entrySet()) {
                String key = entry.getKey();
                List<BusinessTaskResult> value = entry.getValue();
                LevitationEnum levitationEnum = LevitationEnum.getLevitationEnum((String)key);
                String msg = value.stream().map(BusinessTaskResult::getMsg).reduce((v1, v2) -> v1 + v2).orElse("");
                String resultMsg = levitationEnum.getMessage(new Object[]{msg});
                sbr.append(resultMsg);
            }
            return sbr.toString();
        }
        return "";
    }
}

