/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.engine.task;

import java.io.Serializable;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.pa.engine.task.AbstractBusinessSequenceTaskGroup;
import kd.fi.pa.engine.task.BusinessTaskResult;
import kd.fi.pa.engine.task.BusinessTaskResultProcessor;
import kd.fi.pa.engine.task.IDataWorkTask;
import kd.fi.pa.engine.task.IDataWorkTaskManager;
import kd.fi.pa.model.impl.ThreeValueTuple;

public class PABusinessManageSequenceTaskGroup
extends AbstractBusinessSequenceTaskGroup {
    private static final Log logger = LogFactory.getLog(PABusinessManageSequenceTaskGroup.class);

    public PABusinessManageSequenceTaskGroup(Serializable taskKey, Serializable version) {
        super(taskKey, version, new BusinessTaskResultProcessor());
        this.exceptionListener = this::onTaskError;
        this.continueOnSubTaskError = true;
    }

    public void initializeTaskJob() {
        this.initTaskStatistics();
        super.initializeTaskJob();
    }

    protected BusinessTaskResult doTaskJob() {
        logger.info(String.format("[FI-PA] TaskExecute PABusinessManageSequenceTaskGroup doTaskJob begin groupTask:%s", new Object[]{this}));
        try {
            this.taskResult = super.doTaskJob();
        }
        catch (Exception e) {
            this.taskResult = BusinessTaskResult.failed(e);
            throw e;
        }
        logger.info(String.format("[FI-PA] TaskExecute PABusinessManageSequenceTaskGroup doTaskJob end groupTask:%s", new Object[]{this}));
        return (BusinessTaskResult)this.taskResult;
    }

    protected void executeSubTask(int taskIndex, ThreeValueTuple<IDataWorkTask<BusinessTaskResult>, Boolean, Boolean> workTaskInfo) {
        logger.info(String.format("[FI-PA] TaskExecute PABusinessManageSequenceTaskGroup executeSubTask begin taskIndex:%s subTaskInfo:%s", taskIndex, workTaskInfo));
        super.executeSubTask(taskIndex, workTaskInfo);
        logger.info(String.format("[FI-PA] TaskExecute PABusinessManageSequenceTaskGroup executeSubTask end taskIndex:%s subTaskInfo:%s", taskIndex, workTaskInfo));
    }

    protected Future<BusinessTaskResult> processSubTask(IDataWorkTask<BusinessTaskResult> subWorkTask) {
        this.updateTaskStatistics(1, 0, 0, 0);
        return IDataWorkTaskManager.getInstance().submit(subWorkTask, false);
    }

    protected BusinessTaskResult processTaskResult(int taskIndex, IDataWorkTask<BusinessTaskResult> task, Object currentTaskResult) {
        super.processTaskResult(taskIndex, task, currentTaskResult);
        if (currentTaskResult != null) {
            BusinessTaskResult businessTaskResult = (BusinessTaskResult)currentTaskResult;
            Long code = businessTaskResult.getCode();
            if (code == 0L) {
                this.updateTaskStatistics(0, 0, 0, 1);
            } else if (code == 2L) {
                this.updateTaskStatistics(0, 0, 1, 0);
            } else {
                this.updateTaskStatistics(0, 1, 0, 0);
            }
        }
        BusinessTaskResultProcessor processTaskResultFunc = (BusinessTaskResultProcessor)this.processTaskResultFunc;
        this.taskResult = processTaskResultFunc.getManageResult();
        return (BusinessTaskResult)this.taskResult;
    }

    protected void updateTaskStageCode(int newStageCode) {
        super.updateTaskStageCode(newStageCode);
        switch (newStageCode) {
            case 9: {
                this.endTaskStatistics(((BusinessTaskResult)this.taskResult).getMsg());
                break;
            }
            case -9: 
            case 10: {
                this.errorTaskStatistics(BusinessTaskResult.getErrorMsg());
                break;
            }
        }
    }

    protected boolean onException(Throwable exception) {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("[FI-PA] TaskExecute Error PABusinessManageSequenceTaskGroup Msg=%s", exception.getMessage()), exception);
        }
        return this.exceptionListener.onError(exception);
    }

    protected boolean onTaskError(Throwable exception) {
        this.exception = exception;
        return true;
    }
}

